package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.client.loader.URLTextureManager;
import dev.felnull.otyacraftengine.client.util.ClientUtilInit;
import dev.felnull.otyacraftengine.util.OEItemUtil;
import dev.felnull.otyacraftengine.util.OETagUtil;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1785;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import net.minecraft.world.item.*;
import var;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClientHandler {

    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(ClientHandler::onQuit);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ClientHandler::onJoin);
        ClientTooltipEvent.ITEM.register(ClientHandler::onTooltip);
    }

    private static void onJoin(class_746 localPlayer) {
        onReset();
    }

    private static void onQuit(class_746 localPlayer) {
        onReset();
    }

    private static void onReset() {
        ClientUtilInit.clear();
        PlayerInfoManager.getInstance().reload();
        URLTextureManager.getInstance().reload();
    }

    private static void onTooltip(class_1799 itemStack, List<class_2561> list, class_1836 tooltipFlag) {
        if (itemStack.method_7960()) return;
        var item = itemStack.method_7909();

        if (OtyacraftEngine.CONFIG.showTagTooltip) {
            var itemTags = OETagUtil.getTags(item);
            if (item instanceof class_1747 blockItem) {
                var blockTags = OETagUtil.getTags(blockItem.method_7711());
                Set<class_2960> bothTags = new HashSet<>();
                boolean firstItem = false;
                boolean firstBlock = false;

                for (class_2960 tag : itemTags) {
                    if (!blockTags.contains(tag)) {
                        if (!firstItem) {
                            list.add(new class_2585("Item tags").method_27692(class_124.field_1075));
                            firstItem = true;
                        }
                        list.add(new class_2585(" - " + tag));
                    } else {
                        bothTags.add(tag);
                    }
                }

                for (class_2960 blockTag : blockTags) {
                    if (!itemTags.contains(blockTag)) {
                        if (!firstBlock) {
                            list.add(new class_2585("Block tags").method_27692(class_124.field_1075));
                            firstBlock = true;
                        }
                        list.add(new class_2585(" - " + blockTag));
                    } else {
                        bothTags.add(blockTag);
                    }
                }

                if (!bothTags.isEmpty()) {
                    list.add(new class_2585("Both tags").method_27692(class_124.field_1075));
                    for (class_2960 tag : bothTags) {
                        list.add(new class_2585(" - " + tag));
                    }
                }
            } else {
                if (!itemTags.isEmpty()) {
                    list.add(new class_2585("Item tags").method_27692(class_124.field_1075));
                    for (class_2960 tag : itemTags) {
                        list.add(new class_2585(" - " + tag));
                    }
                }
            }
            var entityTypes = getEntityTypesByItem(itemStack);
            Set<class_2960> entityTypeTags = new HashSet<>();
            entityTypes.forEach(n -> entityTypeTags.addAll(OETagUtil.getTags(n)));
            if (!entityTypeTags.isEmpty()) {
                list.add(new class_2585("Entity tags").method_27692(class_124.field_1075));
                for (class_2960 tag : entityTypeTags) {
                    list.add(new class_2585(" - " + tag));
                }
            }
        }

        if (OtyacraftEngine.CONFIG.showModNameTooltip) {
            var modid = class_2378.field_11142.method_10221(item);
            list.add(new class_2585(Platform.getMod(modid.getNamespace()).getName()).method_27692(class_124.field_1077));
        }
    }

    private static Set<class_1299<?>> getEntityTypesByItem(class_1799 stack) {
        var item = stack.method_7909();
        if (item instanceof class_1826 spawnEggItem) {
            return Set.of(spawnEggItem.method_8015(stack.method_7969()));
        } else if (item instanceof class_1785 mobBucketItem) {
            return Set.of(OEItemUtil.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }

}
