package dev.felnull.otyacraftengine.client.renderer.texture;


import ImageFrame;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;
import record;

public class DynamicGifTexture extends class_1043 implements class_1061 {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    public DynamicGifTexture(long duration, ImageFrame... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    @Override
    public void method_4622() {
        int ct = Math.toIntExact(getFrameByTime(System.currentTimeMillis() % duration));
        if (ct != last) {
            OEClientExpectPlatform.setNonClosePixels(this, frames[ct].image());
            method_4524();
            last = ct;
        }
    }

    private int getFrameByTime(long time) {
        long dr = 0;
        for (int i = 0; i < frames.length; i++) {
            if (dr <= time && dr + frames[i].delay > time)
                return i;
            dr += frames[i].delay;
        }
        return 0;
    }

    @Override
    public void close() {
        super.close();
        if (frames != null) {
            for (ImageFrame image : frames) {
                if (image != null)
                    image.image().close();
            }
        }
    }

    public static record ImageFrame(class_1011 image, long delay) {
    }
}