package dev.felnull.otyacraftengine.mixin.client;


import dev.felnull.otyacraftengine.client.gui.subtitle.ICustomTimeSubtitle;
import dev.felnull.otyacraftengine.client.gui.subtitle.IDynamicSubtitle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import var;
import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_359;

@Mixin(class_359.class_360.class)
public class SubtitleMixin implements IDynamicSubtitle, ICustomTimeSubtitle {
    private Supplier<class_243> dynamicLocation;
    private long customTime;

    @Override
    public void setDynamicLocation(Supplier<class_243> location) {
        this.dynamicLocation = location;
    }

    @Override
    public Supplier<class_243> getDynamicLocation() {
        return dynamicLocation;
    }

    @Override
    public void setCustomTime(long time) {
        this.customTime = 3000L - time;
    }

    @Override
    public long getCustomTime() {
        return customTime;
    }

    @Inject(method = "getLocation", at = @At("RETURN"), cancellable = true)
    private void getLocation(CallbackInfoReturnable<class_243> cir) {
        if (dynamicLocation != null) {
            var loc = dynamicLocation.get();
            if (loc != null)
                cir.setReturnValue(loc);
        }
    }

    @Inject(method = "getTime", at = @At("RETURN"), cancellable = true)
    private void getTime(CallbackInfoReturnable<Long> cir) {
        cir.setReturnValue(cir.getReturnValue() - customTime);
    }
}


