package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public class FixedButtonsList<E> extends class_339 implements IOEBaseComponent {
    private static final class_310 mc = class_310.method_1551();
    private final List<E> list;
    private final Function<E, class_2561> listName;
    private final PressEntry<E> onPress;
    private final int xTexStart;
    private final int yTexStart;
    private final int wTex;
    private final int hTex;
    private final class_2960 resourceLocation;
    protected int num;
    protected int hoveredNumber;
    protected boolean isHoveredScrollBar;
    private float scrollAmount;
    private boolean canScroll;

    public FixedButtonsList(int x, int y, int w, int h, class_2960 resource, int tx, int ty, int tw, int th, int num, class_2561 name, List<E> list, Function<E, class_2561> listName, PressEntry<E> onPressEntry) {
        super(x, y, w, h, name);
        this.list = list;
        this.listName = listName;
        this.num = num;
        this.onPress = onPressEntry;
        this.resourceLocation = resource;
        this.xTexStart = tx;
        this.yTexStart = ty;
        this.wTex = tw;
        this.hTex = th;
    }

    @Override
    public void method_37020(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mx, int my, float parTick) {
        if (field_22764) {
            this.hoveredNumber = (my - field_22761) / getOneButtonHeight();
            this.isHoveredScrollBar = mx >= this.field_22760 + getOneButtonWidth() && my >= this.field_22761 && mx < this.field_22760 + this.field_22758 && my < this.field_22761 + this.field_22759;
        }
        super.method_25394(poseStack, mx, my, parTick);
    }

    @Override
    public void method_25359(class_4587 poseStack, int mx, int my, float parTick) {
        for (int i = 0; i < num; i++) {
            int cn = getCurrentFirstNumber() + i;

            if (cn >= list.size() || cn < 0)
                break;

            renderOneButton(poseStack, getList().get(cn), cn, i, field_22760, field_22761 + getOneButtonHeight() * i, mx, my, parTick);
        }

        renderScrollbar(poseStack, this.field_22760 + getOneButtonWidth(), this.field_22761, 9, field_22759);

    }

    protected void renderScrollbar(class_4587 poseStack, int x, int y, int w, int h) {

        boolean hv = isHoveredScrollBar();

        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y, xTexStart + (hv ? 9 : 0), yTexStart, 9, 3, wTex, hTex);
        int bsct = (field_22759 - 6) / 16;
        for (int i = 0; i < bsct; i++) {
            OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + 3 + (i * 16), xTexStart + (hv ? 9 : 0), yTexStart + 3, 9, 16, wTex, hTex);
        }
        int bsam = (field_22759 - 6) % 16;
        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + 3 + (bsct * 16), xTexStart + (hv ? 9 : 0), yTexStart + 3, 9, bsam, wTex, hTex);
        OERenderUtil.drawTexture(resourceLocation, poseStack, x, y + field_22759 - 3, xTexStart + (hv ? 9 : 0), yTexStart + 19, 9, 3, wTex, hTex);

        int barHeight = getBarHeight();
        float barY = ((field_22759 - 2) - barHeight) * scrollAmount;


        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 1 + barY, xTexStart + (hv ? 7 : 0), yTexStart + 22, 7, 3, wTex, hTex);
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; i++) {
            OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 4 + (i * 14) + barY, xTexStart + (hv ? 7 : 0), yTexStart + 25, 7, 14, wTex, hTex);
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 4 + (ssct * 14) + barY, xTexStart + (hv ? 7 : 0), yTexStart + 25, 7, ssam, wTex, hTex);
        OERenderUtil.drawTexture(resourceLocation, poseStack, x + 1, y + 1 + barHeight - 3 + barY, xTexStart + (hv ? 7 : 0), yTexStart + 39, 7, 3, wTex, hTex);
    }


    protected void renderOneButton(class_4587 poseStack, E item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, field_22757);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, this.field_22765);
        int k = this.method_25356(this.isHoveredOrFocused(bnum));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.method_25302(poseStack, x, y, 0, 46 + k * 20, getOneButtonWidth() / 2, getOneButtonHeight());
        this.method_25302(poseStack, x + getOneButtonWidth() / 2, y, 200 - getOneButtonWidth() / 2, 46 + k * 20, getOneButtonWidth() / 2, getOneButtonHeight());
        this.method_25353(poseStack, mc, mx, my);

        int l = this.field_22763 ? 16777215 : 10526880;
        method_27534(poseStack, mc.field_1772, this.getMessage(lnum), this.field_22760 + getOneButtonWidth() / 2, y + (getOneButtonHeight() - 8) / 2, l | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    public List<E> getList() {
        return list;
    }

    public boolean isHoveredOrFocused(int lnum) {
        return method_25367() && hoveredNumber == lnum && !isHoveredScrollBar;
    }

    public class_2561 getMessage(int index) {
        return listName.apply(list.get(index));
    }

    public int getOneButtonHeight() {
        return field_22759 / num;
    }

    public int getOneButtonWidth() {
        return field_22758 - 9;
    }

    public float getScrollAmount() {
        return scrollAmount;
    }

    public void setScrollAmount(float d) {
        this.scrollAmount = class_3532.method_15363(d, 0f, 1f);
    }

    @Override
    public void method_25348(double mx, double my) {
        onPress((int) ((my - field_22761) / getOneButtonHeight()));
    }

    public boolean isHoveredScrollBar() {
        return this.method_25367() && isHoveredScrollBar;
    }

    public void onPress(int num) {
        int cn = getCurrentFirstNumber() + num;

        if (cn < list.size() && isHoveredOrFocused(num))
            onPress.onPressEntry(this, list.get(cn), cn, num);
    }

    public int getBarHeight() {
        return class_3532.method_15340((field_22759 - 2) / ((list.size() / num) + 1), 10, field_22759 - 2);
    }

    protected int getCurrentFirstNumber() {


        if (list.size() <= num)
            return 0;

        return (int) ((list.size() - num) * scrollAmount);
    }

    @Override
    public boolean method_25402(double mx, double my, int i) {
        canScroll = isHoveredScrollBar();
        scroll(my);
        return super.method_25402(mx, my, i);
    }

    @Override
    public boolean method_25403(double mx, double my, int i, double f, double g) {
        scroll(my);
        return super.method_25403(mx, my, i, f, g);
    }

    @Override
    public boolean method_25401(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - (float) f * ((float) num / (float) field_22759));
        return true;
    }

    public void scroll(double mouseY) {
        if (canScroll) {
            int cy = (int) (mouseY - this.field_22761 - 1 - getBarHeight() / 2);
            int sa = field_22759 - 2 - getBarHeight();
            if (sa > 0) {
                setScrollAmount((float) cy / (float) sa);
            }
        }
    }

    public static interface PressEntry<E> {
        void onPressEntry(FixedButtonsList<E> buttonsList, E item, int itemNum, int num);
    }
}
