/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.screen.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.debug.MotionDebug;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.gui.components.BetterEditBox;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.gui.components.SwitchButton;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.mixin.client.ScreenAccessor;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionDebugScreen
extends OEBaseScreen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final SimpleDateFormat saveDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final class_1160 lastSocketRotation = new class_1160();
    private static boolean enableVisible = true;
    public static boolean pause;
    private static boolean socketRotationFixX;
    private static boolean socketRotationFixY;
    private static boolean socketRotationFixZ;
    private static boolean enableEdit;
    private class_4185 editTypeButton;
    private SwitchButton enableEditSwitch;
    private BetterEditBox xEditBox;
    private BetterEditBox yEditBox;
    private BetterEditBox zEditBox;
    private MotionListWidget motionListWidget;
    private class_4185 startButton;
    private class_4185 stopButton;
    private BetterEditBox motionSpeedEditBox;
    private BetterEditBox ratioEditBox;

    public MotionDebugScreen(@Nullable class_437 parent) {
        super((class_2561)new class_2585("Motion Debug"), parent);
    }

    protected void method_25426() {
        super.method_25426();
        class_4185 vib = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 - 13, 3, 10, 10, (class_2561)new class_2585("I"), n -> {
            ScreenAccessor accessor = (ScreenAccessor)((Object)this);
            enableVisible = !enableVisible;
            accessor.getRenderables().forEach(m -> {
                if (m == n) {
                    return;
                }
                if (m instanceof class_339) {
                    class_339 w = (class_339)m;
                    w.field_22764 = enableVisible;
                }
            });
        }));
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        int st = 3 + 9 * 6 + 2;
        SwitchButton etsw = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st, (class_2561)new class_2585("Enable temporary Motion"), n -> this.getMotionDebug().setEnableTemporary(n.isEnable()), true));
        etsw.setEnable(this.getMotionDebug().isEnableTemporary());
        this.xEditBox = (BetterEditBox)this.method_37063((class_364)new BetterEditBox(123, st, 50, 12, this.xEditBox, (class_2561)new class_2585("x")));
        this.yEditBox = (BetterEditBox)this.method_37063((class_364)new BetterEditBox(176, st, 50, 12, this.yEditBox, (class_2561)new class_2585("y")));
        this.zEditBox = (BetterEditBox)this.method_37063((class_364)new BetterEditBox(229, st, 50, 12, this.zEditBox, (class_2561)new class_2585("z")));
        Predicate<String> fpr = n -> {
            try {
                Float.parseFloat(n);
                return true;
            }
            catch (Exception exception) {
                return n.isEmpty();
            }
        };
        this.xEditBox.method_1890(fpr);
        this.yEditBox.method_1890(fpr);
        this.zEditBox.method_1890(fpr);
        this.method_37063((class_364)new class_4185(123, st + 15, 50, 20, (class_2561)new class_2585("Input"), n -> {
            class_1160 cm = this.getMotion();
            this.xEditBox.method_1852(String.valueOf(cm.method_4943()));
            this.yEditBox.method_1852(String.valueOf(cm.method_4945()));
            this.zEditBox.method_1852(String.valueOf(cm.method_4947()));
        }));
        this.method_37063((class_364)new class_4185(176, st + 15, 50, 20, (class_2561)new class_2585("Output"), n -> {
            if (!(this.xEditBox.method_1882().isEmpty() || this.yEditBox.method_1882().isEmpty() || this.zEditBox.method_1882().isEmpty())) {
                try {
                    float x = Float.parseFloat(this.xEditBox.method_1882());
                    float y = Float.parseFloat(this.yEditBox.method_1882());
                    float z = Float.parseFloat(this.zEditBox.method_1882());
                    this.setMotion(x, y, z);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        this.method_37063((class_364)new class_4185(229, st + 15, 50, 20, (class_2561)new class_2585("Copy"), n -> {
            if (!(this.xEditBox.method_1882().isEmpty() || this.yEditBox.method_1882().isEmpty() || this.zEditBox.method_1882().isEmpty())) {
                MotionDebugScreen.mc.field_1774.method_1455(String.format("%sf, %sf, %sf", this.xEditBox.method_1882(), this.yEditBox.method_1882(), this.zEditBox.method_1882()));
            }
        }));
        this.method_37063((class_364)new class_4185(123, st + 15 + 23, 50, 20, (class_2561)new class_2585("All Copy"), n -> {
            MotionPoint p = this.getMotionDebug().createPoint();
            class_1160 pos = p.getPosition();
            MotionRotation rot = p.getRotation();
            class_1160 ang = rot.angle();
            class_1160 ori = rot.origin();
            Triple<Boolean, Boolean, Boolean> res = rot.reset();
            MotionDebugScreen.mc.field_1774.method_1455(String.format("%sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %s, %s, %s", Float.valueOf(pos.method_4943()), Float.valueOf(pos.method_4945()), Float.valueOf(pos.method_4947()), Float.valueOf(ang.method_4943()), Float.valueOf(ang.method_4945()), Float.valueOf(ang.method_4947()), Float.valueOf(ori.method_4943()), Float.valueOf(ori.method_4945()), Float.valueOf(ori.method_4947()), res.getLeft(), res.getMiddle(), res.getLeft()));
        }));
        this.motionListWidget = (MotionListWidget)this.method_37063((class_364)new MotionListWidget(this.field_22789 - 3 - 120, st - 20, 120, 50, 5, this.getMotionDebug().getPoints(), (widget, item) -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                this.getMotionDebug().setPoint(e);
            }
        }, this.motionListWidget));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120, st + 50 + 3 - 20, 27, 20, (class_2561)new class_2585("Add"), n -> {
            MotionPoint ne = this.getMotionDebug().createPoint();
            this.getMotionDebug().getPoints().add(ne);
            this.motionListWidget.setSelectedEntry(this.getMotionDebug().getPoints().size() - 1);
            this.getMotionDebug().setRotationReset(false, false, false);
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 30, st + 50 + 3 - 20, 27, 20, (class_2561)new class_2585("Del"), n -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                int num = this.motionListWidget.getSelectedEntryIndex();
                this.getMotionDebug().getPoints().remove(num);
                this.motionListWidget.setSelectedEntry(num - 1);
            }
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 60, st + 50 + 3 - 20, 27, 20, (class_2561)new class_2585("Set"), n -> {
            int num = this.motionListWidget.getSelectedEntryIndex();
            this.getMotionDebug().getPoints().set(num, this.getMotionDebug().createPoint());
            this.motionListWidget.setSelectedEntry(num);
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 90, st + 50 + 3 - 20, 27, 20, (class_2561)new class_2585("Inj"), n -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                MotionPoint ne = this.getMotionDebug().createPoint();
                int ei = this.motionListWidget.getSelectedEntryIndex();
                if (ei - 1 >= this.getMotionDebug().getPoints().size()) {
                    this.getMotionDebug().getPoints().add(ne);
                    this.motionListWidget.setSelectedEntry(this.getMotionDebug().getPoints().size() - 1);
                } else {
                    this.getMotionDebug().getPoints().add(ei + 1, ne);
                    this.motionListWidget.setSelectedEntry(ei + 1);
                }
                this.getMotionDebug().setRotationReset(false, false, false);
            }
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120, st + 50 + 3 - 20 + 23, 27, 20, (class_2561)new class_2585("Output"), n -> {
            if (this.getMotionDebug().getPoints().isEmpty()) {
                return;
            }
            Path pt = OEPaths.getClientOEFolderPath().resolve("debug").resolve("motion");
            pt.toFile().mkdirs();
            Motion motion = this.getMotionDebug().createMotion();
            JsonObject jo = motion.toJson();
            try (FileWriter writer = new FileWriter(pt.resolve(saveDateFormat.format(new Date()) + ".json").toFile());){
                GSON.toJson((JsonElement)jo, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 30, st + 50 + 3 - 20 + 23, 27, 20, (class_2561)new class_2585("Input"), n -> {
            File[] files = OEClientUtil.openFileChooser(null, OEPaths.getClientOEFolderPath(), null, false);
            this.loadJson(files);
        }));
        this.startButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 60, st + 50 + 3 - 20 + 23, 27, 20, (class_2561)new class_2585("Start"), n -> {
            n.field_22763 = false;
            this.stopButton.field_22763 = true;
            try {
                String str = this.motionSpeedEditBox.method_1882();
                long val = str.isEmpty() ? 3000L : Math.max(Long.parseLong(str), 1L);
                this.getMotionDebug().startMotion(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }));
        this.startButton.field_22763 = !this.getMotionDebug().isMotionPlaying();
        this.stopButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 - 3 - 120 + 90, st + 50 + 3 - 20 + 23, 27, 20, (class_2561)new class_2585("Stop"), n -> {
            n.field_22763 = false;
            this.startButton.field_22763 = true;
            this.getMotionDebug().stopMotion();
        }));
        this.stopButton.field_22763 = this.getMotionDebug().isMotionPlaying();
        this.motionSpeedEditBox = (BetterEditBox)this.method_37063((class_364)new BetterEditBox(this.field_22789 - 3 - 120, st + 50 + 3 - 20 + 23 + 23, 120, 12, this.motionSpeedEditBox, (class_2561)new class_2585("Motion Speed")));
        this.motionSpeedEditBox.method_1890(fpr);
        this.ratioEditBox = (BetterEditBox)this.method_37063((class_364)new BetterEditBox(this.field_22789 - 3 - 120, st + 50 + 3 - 20 + 23 + 23 + 20, 50, 12, this.ratioEditBox, (class_2561)new class_2585("Ratio")));
        this.ratioEditBox.method_1890(fpr);
        this.ratioEditBox.method_1852(String.valueOf(this.getMotionDebug().getRatio()));
        this.ratioEditBox.method_1863(n -> {
            try {
                float r = this.ratioEditBox.method_1882().isEmpty() ? 1.0f : Float.parseFloat(this.ratioEditBox.method_1882());
                this.getMotionDebug().setRatio(r);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        SwitchButton tsw = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 17, (class_2561)new class_2585("Edit temporary Motion"), n -> this.getMotionDebug().setEditTemporary(n.isEnable()), true));
        tsw.setEnable(this.getMotionDebug().isEditTemporary());
        this.editTypeButton = (class_4185)this.method_37063((class_364)new class_4185(3, st += 15, 120, 20, (class_2561)new class_2585(this.getMotionDebug().getEditType().name()), n -> this.setNextEditType()));
        this.method_37063((class_364)new class_4185(3, st += 24, 120, 20, (class_2561)new class_2585("Reset"), n -> this.getMotionDebug().reset()));
        this.enableEditSwitch = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 24, (class_2561)new class_2585("Enable Edit"), n -> {
            enableEdit = n.isEnable();
        }, true));
        this.enableEditSwitch.setEnable(enableEdit);
        SwitchButton srswfx = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 17, (class_2561)new class_2585("Socket Rotation Fix X"), n -> {
            socketRotationFixX = n.isEnable();
        }, true));
        srswfx.setEnable(socketRotationFixX);
        SwitchButton srswfy = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 17, (class_2561)new class_2585("Socket Rotation Fix Y"), n -> {
            socketRotationFixY = n.isEnable();
        }, true));
        srswfy.setEnable(socketRotationFixY);
        SwitchButton srswfz = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 17, (class_2561)new class_2585("Socket Rotation Fix Z"), n -> {
            socketRotationFixZ = n.isEnable();
        }, true));
        srswfz.setEnable(socketRotationFixZ);
        this.method_37063((class_364)new class_4185(3, st += 15, 40, 20, (class_2561)new class_2585("Reset X"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset(true, (Boolean)o.getMiddle(), (Boolean)o.getRight());
            class_1160 oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new class_1160(oa.method_4943() % 360.0f, oa.method_4945(), oa.method_4947()));
        }));
        this.method_37063((class_364)new class_4185(46, st, 40, 20, (class_2561)new class_2585("Reset Y"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset((Boolean)o.getLeft(), true, (Boolean)o.getRight());
            class_1160 oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new class_1160(oa.method_4943(), oa.method_4945() % 360.0f, oa.method_4947()));
        }));
        this.method_37063((class_364)new class_4185(89, st, 40, 20, (class_2561)new class_2585("Reset Z"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset((Boolean)o.getLeft(), (Boolean)o.getMiddle(), true);
            class_1160 oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new class_1160(oa.method_4943(), oa.method_4945(), oa.method_4947() % 360.0f));
        }));
        SwitchButton fosw = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 24, (class_2561)new class_2585("Fix Origin"), n -> this.getMotionDebug().setFixOrigin(n.isEnable()), true));
        fosw.setEnable(this.getMotionDebug().isFixOrigin());
        SwitchButton sosw = (SwitchButton)this.method_37063((class_364)new SwitchButton(3, st += 17, (class_2561)new class_2585("Show Origin"), n -> this.getMotionDebug().setShowOrigin(n.isEnable()), true));
        sosw.setEnable(this.getMotionDebug().isShowOrigin());
        ScreenAccessor sca = (ScreenAccessor)((Object)this);
        sca.getRenderables().forEach(n -> {
            if (n == vib) {
                return;
            }
            if (n instanceof class_339) {
                class_339 w = (class_339)n;
                w.field_22764 = enableVisible;
            }
        });
    }

    protected void loadJson(File[] files) {
        if (files == null || files.length != 1) {
            return;
        }
        File fil = files[0];
        JsonObject jo = null;
        try (FileReader reader = new FileReader(fil);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (jo == null) {
            return;
        }
        this.getMotionDebug().setMotion(Motion.of(jo));
        this.motionListWidget.setSelectedEntry(0);
    }

    public void setNextEditType() {
        MotionDebug.EditType et = this.getMotionDebug().getEditType();
        this.getMotionDebug().setEditType(MotionDebug.EditType.values()[(et.ordinal() + 1) % MotionDebug.EditType.values().length]);
        this.editTypeButton.method_25355((class_2561)new class_2585(this.getMotionDebug().getEditType().name()));
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 82) {
            this.setNextEditType();
            return true;
        }
        if (i == 87) {
            enableEdit = !enableEdit;
            this.enableEditSwitch.setEnable(enableEdit);
            return true;
        }
        if (enableEdit) {
            boolean sflg = OEClientUtil.isKeyInput(MotionDebugScreen.mc.field_1690.field_1832);
            if (i == 263) {
                this.addMotion(0.0f, -1.0f, 0.0f);
                return true;
            }
            if (i == 262) {
                this.addMotion(0.0f, 1.0f, 0.0f);
                return true;
            }
            if (i == 265) {
                if (sflg) {
                    this.addMotion(0.0f, 0.0f, -1.0f);
                } else {
                    this.addMotion(-1.0f, 0.0f, 0.0f);
                }
                return true;
            }
            if (i == 264) {
                if (sflg) {
                    this.addMotion(0.0f, 0.0f, 1.0f);
                } else {
                    this.addMotion(1.0f, 0.0f, 0.0f);
                }
                return true;
            }
        }
        return super.method_25404(i, j, k);
    }

    public void method_25394(@NotNull class_4587 poseStack, int x, int y, float f) {
        if (enableVisible) {
            this.method_25420(poseStack);
        }
        super.method_25394(poseStack, x, y, f);
        this.drawTextBase(poseStack, MotionDebugScreen.mc.field_1770, 3, 3, 0xFFFFFF);
        String string = "Motion Point - " + MotionDebugScreen.createMotionText(this.getMotionDebug().getPosition(), this.getMotionDebug().getRotation().angle(), this.getMotionDebug().getRotation().origin());
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        this.drawTextBase(poseStack, string, 3, 3 + 9, 0xFFFFFF);
        Triple<Boolean, Boolean, Boolean> reset = this.getMotionDebug().getRotation().reset();
        String string2 = String.format("Reset: [X: %s, Y: %s, Z: %s]", (Boolean)reset.getLeft() != false ? "T" : "F", (Boolean)reset.getMiddle() != false ? "T" : "F", (Boolean)reset.getRight() != false ? "T" : "F");
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        this.drawTextBase(poseStack, string2, 3, 3 + 9 * 2, 0xFFFFFF);
        String string3 = "Temporary - " + MotionDebugScreen.createMotionText(this.getMotionDebug().getTemporaryPosition(), this.getMotionDebug().getTemporaryRotation().angle(), this.getMotionDebug().getTemporaryRotation().origin());
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        this.drawTextBase(poseStack, string3, 3, 3 + 9 * 3, 0xFFFFFF);
        String string4 = "Sensitivity: " + this.getMotionDebug().getSensitivity();
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        this.drawTextBase(poseStack, string4, 3, 3 + 9 * 4, 0xFFFFFF);
        class_1160 spos = SocketDebugService.getPosition(f);
        class_1160 srot = SocketDebugService.getAngele(f);
        String string5 = !SocketDebugService.isConnected() ? "Socket - Not connected" : String.format("Socket - Pos: [X: %s  Y: %s  Z: %s], Rot: [X: %s, Y: %s, Z: %s]", (int)spos.method_4943(), (int)spos.method_4945(), (int)spos.method_4947(), (int)srot.method_4943(), (int)srot.method_4945(), (int)srot.method_4947());
        Objects.requireNonNull(MotionDebugScreen.mc.field_1772);
        this.drawTextBase(poseStack, string5, 3, 3 + 9 * 5, 0xFFFFFF);
    }

    public void method_25393() {
        super.method_25393();
        if (!enableEdit) {
            return;
        }
        class_1160 sr = SocketDebugService.getAngele(0.0f);
        class_1160 sa = new class_1160(lastSocketRotation.method_4943() - sr.method_4943(), lastSocketRotation.method_4945() - sr.method_4945(), lastSocketRotation.method_4947() - sr.method_4947());
        float vx = 0.0f;
        float vy = 0.0f;
        float vz = 0.0f;
        if (!socketRotationFixX) {
            vx = sa.method_4945();
        }
        if (!socketRotationFixY) {
            vy = -sa.method_4943();
        }
        if (!socketRotationFixZ) {
            vz = sa.method_4947();
        }
        this.getMotionDebug().addRotationAngle(vx, vy, vz);
        lastSocketRotation.method_4949(sr.method_4943(), sr.method_4945(), sr.method_4947());
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (!this.isHoveredWidget((float)d, (float)e) && enableEdit) {
            boolean l;
            boolean bl = l = i == 0;
            if (l) {
                this.addMotion((float)g, (float)f, 0.0f);
            } else {
                this.addMotion(0.0f, (float)f, (float)g);
            }
        }
        return super.method_25403(d, e, i, f, g);
    }

    public boolean method_25401(double x, double y, double f) {
        if (!this.isHoveredWidget((float)x, (float)y)) {
            float v = this.getMotionDebug().getSensitivity();
            if (OEClientUtil.isKeyInput(MotionDebugScreen.mc.field_1690.field_1832)) {
                f *= (double)0.1f;
            }
            v = (float)((double)v + f * (double)0.1f);
            this.getMotionDebug().setSensitivity(Math.max(v, 0.0f));
        }
        return super.method_25401(x, y, f);
    }

    private boolean isHoveredWidget(float x, float y) {
        ScreenAccessor sa = (ScreenAccessor)((Object)this);
        return sa.getRenderables().stream().filter(n -> n instanceof class_339).map(n -> (class_339)n).filter(n -> x >= (float)n.field_22760 && y >= (float)n.field_22761 && x < (float)(n.field_22760 + n.method_25368()) && (double)y < (double)(n.field_22761 + n.method_25364())).anyMatch(n -> true);
    }

    private void setMotion(float x, float y, float z) {
        switch (this.getMotionDebug().getEditType()) {
            case POSITION: {
                this.getMotionDebug().setPosition(new class_1160(x, y, z));
                break;
            }
            case ROTATION: {
                this.getMotionDebug().setRotationAngle(new class_1160(x, y, z));
                break;
            }
            case ROTATION_ORIGIN: {
                this.getMotionDebug().setRotationOrigin(new class_1160(x, y, z));
            }
        }
    }

    private class_1160 getMotion() {
        return switch (this.getMotionDebug().getEditType()) {
            default -> throw new IncompatibleClassChangeError();
            case MotionDebug.EditType.POSITION -> this.getMotionDebug().getPosition();
            case MotionDebug.EditType.ROTATION -> this.getMotionDebug().getRotation().angle();
            case MotionDebug.EditType.ROTATION_ORIGIN -> this.getMotionDebug().getRotation().origin();
        };
    }

    private void addMotion(float x, float y, float z) {
        float sc = this.getMotionDebug().getSensitivity();
        x *= sc;
        y *= sc;
        z *= sc;
        if (this.getMotionDebug().isEditTemporary()) {
            switch (this.getMotionDebug().getEditType()) {
                case POSITION: {
                    this.getMotionDebug().addTemporaryPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                    break;
                }
                case ROTATION: {
                    this.getMotionDebug().addTemporaryRotationAngle(-x, -y, -z);
                    break;
                }
                case ROTATION_ORIGIN: {
                    this.getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
                }
            }
        } else {
            switch (this.getMotionDebug().getEditType()) {
                case POSITION: {
                    this.getMotionDebug().addPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                    break;
                }
                case ROTATION: {
                    this.getMotionDebug().addRotationAngle(-x, -y, -z);
                    break;
                }
                case ROTATION_ORIGIN: {
                    this.getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
                }
            }
        }
    }

    private MotionDebug getMotionDebug() {
        return MotionDebug.getInstance();
    }

    private static String createMotionText(class_1160 pos, class_1160 angle, class_1160 origin) {
        return String.format("Pos: [X: %s  Y: %s  Z: %s], Angle: [X: %s, Y: %s, Z: %s], Origin: [X: %s, Y: %s, Z: %s]", Float.valueOf(pos.method_4943()), Float.valueOf(pos.method_4945()), Float.valueOf(pos.method_4947()), Float.valueOf(angle.method_4943()), Float.valueOf(angle.method_4945()), Float.valueOf(angle.method_4947()), Float.valueOf(origin.method_4943()), Float.valueOf(origin.method_4945()), Float.valueOf(origin.method_4947()));
    }

    public boolean method_25421() {
        return pause;
    }

    static {
        socketRotationFixX = true;
        socketRotationFixY = true;
        socketRotationFixZ = true;
        enableEdit = true;
    }

    private static class MotionListWidget
    extends FixedListWidget<MotionPoint> {
        public MotionListWidget(int x, int y, int width, int height, int entryShowCount, @NotNull List<MotionPoint> entryList, @Nullable FixedListWidget.PressEntry<MotionPoint> onPressEntry, MotionListWidget old) {
            super(x, y, width, height, (class_2561)new class_2585("Motion List"), entryShowCount, entryList, MotionPoint::getText, onPressEntry, true, old);
        }
    }
}

