package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import dev.felnull.fnjl.util.FNColorUtil;
import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.Objects;
import java.util.UUID;

/**
 * 描画系を簡易に実装させる
 *
 * @author MORIMORI0317
 * @since 1.0
 */
@Environment(EnvType.CLIENT)
public class OERenderUtil {
    private static final class_310 mc = class_310.method_1551();
    public static final float MIN_BREADTH = 1.0E-3F;
    public static boolean SKIP_TRANSANDROT_MODELPART;

    public static void drawFill(@NotNull class_4587 poseStack, float x, float y, float w, float h, int color) {
        innerFill(poseStack.method_23760().method_23761(), x, y, w, h, color);
    }

    private static void innerFill(class_1159 matrix4f, float i, float j, float k, float l, int m) {
        float n;
        if (i < k) {
            n = i;
            i = k;
            k = n;
        }

        if (j < l) {
            n = j;
            j = l;
            l = n;
        }

        float f = (float) (m >> 24 & 255) / 255.0F;
        float g = (float) (m >> 16 & 255) / 255.0F;
        float h = (float) (m >> 8 & 255) / 255.0F;
        float o = (float) (m & 255) / 255.0F;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, i, l, 0.0F).method_22915(g, h, o, f).method_1344();
        bufferBuilder.method_22918(matrix4f, k, l, 0.0F).method_22915(g, h, o, f).method_1344();
        bufferBuilder.method_22918(matrix4f, k, j, 0.0F).method_22915(g, h, o, f).method_1344();
        bufferBuilder.method_22918(matrix4f, i, j, 0.0F).method_22915(g, h, o, f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309(bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    /**
     * 文字スプライトを描画
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param text              文字
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param color             色
     */
    public static void renderCenterTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_22904(x, y, z);
        poseStack.method_22905(0.010416667F * size, -0.010416667F * size, 0.010416667F * size);
        mc.field_1772.method_30882(text, ((float) -mc.field_1772.method_27525(text) / 2f) + textX, -mc.field_1772.field_2000 + textY, color, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    /**
     * 文字スプライトを描画
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param text              文字
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     */
    public static void renderCenterTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_22904(x, y, z);
        poseStack.method_22905(0.010416667F * size, -0.010416667F * size, 0.010416667F * size);
        mc.field_1772.method_30882(text, ((float) -mc.field_1772.method_27525(text) / 2f) + textX, -mc.field_1772.field_2000 + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    /**
     * 文字スプライトを描画
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param text              文字
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param color             色
     */
    public static void renderTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_22904(x, y, z);
        poseStack.method_22905(0.010416667F * size, -0.010416667F * size, 0.010416667F * size);
        mc.field_1772.method_30882(text, textX, -mc.field_1772.field_2000 + textY, color, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    /**
     * 文字スプライトを描画
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param text              文字
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     */
    public static void renderTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.method_22903();
        poseStack.method_22904(x, y, z);
        poseStack.method_22905(0.010416667F * size, -0.010416667F * size, 0.010416667F * size);
        mc.field_1772.method_30882(text, textX, -mc.field_1772.field_2000 + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.method_22909();
    }

    /**
     * 幅を固定して文字を描画
     * 幅に入りきらないと縮小し描画される
     *
     * @param poseStack PoseStack
     * @param text      文字
     * @param x         中央X
     * @param y         Y
     * @param color     色(ARGB)
     * @param width     幅
     */
    public static void drawFixedWidthText(class_4587 poseStack, class_2561 text, float x, float y, int color, float width) {
        int size = mc.field_1772.method_27525(text);
        poseStack.method_22903();
        if (size > width) {
            float scale = width / size;
            x /= scale;
            y /= scale;
            poseScaleAll(poseStack, scale);
        }
        mc.field_1772.method_30883(poseStack, text, x, y, color);
        poseStack.method_22909();
    }

    /**
     * 幅を固定して文字を描画
     * 幅に入りきらないと縮小し描画される
     *
     * @param poseStack PoseStack
     * @param text      文字
     * @param x         中央X
     * @param y         Y
     * @param color     色(ARGB)
     * @param width     幅
     */
    public static void drawFixedWidthText(class_4587 poseStack, String text, float x, float y, int color, float width) {
        int size = mc.field_1772.method_1727(text);
        poseStack.method_22903();
        if (size > width) {
            float scale = width / size;
            x /= scale;
            y /= scale;
            poseScaleAll(poseStack, scale);
        }
        mc.field_1772.method_1729(poseStack, text, x, y, color);
        poseStack.method_22909();
    }

    /**
     * 中央ぞろえ文字描画
     *
     * @param poseStack PoseStack
     * @param text      文字
     * @param x         中央X
     * @param y         Y
     * @param color     色(ARGB)
     * @since 2.0
     */
    public static void drawCenterText(class_4587 poseStack, class_2561 text, float x, float y, int color) {
        mc.field_1772.method_30883(poseStack, text, x - ((float) mc.field_1772.method_27525(text) / 2f), y, color);
    }

    /**
     * 中央ぞろえ文字描画
     *
     * @param poseStack PoseStack
     * @param str       文字
     * @param x         中央X
     * @param y         Y
     * @param color     色(ARGB)
     * @since 2.0
     */
    public static void drawCenterText(class_4587 poseStack, String str, float x, float y, int color) {
        mc.field_1772.method_1729(poseStack, str, x - ((float) mc.field_1772.method_1727(str) / 2f), y, color);
    }

    /**
     * GUI上でUUIDから取得したプレイヤーの顔を描画する
     *
     * @param poseStack PoseStack
     * @param uuid      プレイヤーUUID
     * @param x         X
     * @param y         Y
     * @since 2.0
     */
    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y) {
        drawPlayerFace(poseStack, uuid, x, y, 8);
    }

    /**
     * GUI上でUUIDから取得したプレイヤーの顔を描画する
     * サイズ変更可
     *
     * @param poseStack PoseStack
     * @param uuid      プレイヤーUUID
     * @param x         X
     * @param y         Y
     * @param size      サイズ
     * @since 2.0
     */
    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8f;
        class_2960 plskin = OETextureUtil.getPlayerSkinTexture(uuid);
        drawTexture(plskin, poseStack, x, y, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc);
        drawTexture(plskin, poseStack, x, y, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc);
        poseStack.method_22909();
    }

    /**
     * GUI上で名前から取得したプレイヤーの顔を描画する
     *
     * @param poseStack PoseStack
     * @param name      プレイヤー名
     * @param x         X
     * @param y         Y
     */
    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y) {
        drawPlayerFace(poseStack, name, x, y, 8);
    }

    /**
     * GUI上で名前から取得したプレイヤーの顔を描画する
     * サイズ変更可
     *
     * @param poseStack PoseStack
     * @param name      プレイヤー名
     * @param x         X
     * @param y         Y
     * @param size      サイズ
     * @since 2.0
     */
    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8f;
        class_2960 plskin = OETextureUtil.getPlayerSkinTexture(name);
        drawTexture(plskin, poseStack, x, y, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc);
        drawTexture(plskin, poseStack, x, y, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc);
        poseStack.method_22909();
    }

    /**
     * GUI上でテクスチャを描画する
     *
     * @param location            テクスチャ
     * @param poseStack           PoseStack
     * @param x                   X
     * @param y                   Y
     * @param textureStartX       テクスチャの開始地点X
     * @param textureStartY       テクスチャの開始地点Y
     * @param textureFinishWidth  テクスチャの終了地点X
     * @param textureFinishHeight テクスチャの終了地点Y
     */
    public static void drawTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight) {
        drawTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256f, 256f);
    }


    /**
     * GUI上でテクスチャを描画する
     *
     * @param poseStack PoseStack
     * @param x         X
     * @param y         Y
     * @param texture   テクスチャ指定
     */
    public static void drawTexture(class_4587 poseStack, float x, float y, TextureSpecifyLocation texture) {
        drawTexture(texture.location(), poseStack, x, y, texture.x(), texture.y(), texture.width(), texture.height(), texture.sizeWidth(), texture.sizeHeight());
    }

    /**
     * GUI上でテクスチャを描画する
     *
     * @param location            テクスチャ
     * @param poseStack           PoseStack
     * @param x                   X
     * @param y                   Y
     * @param textureStartX       テクスチャの開始地点X
     * @param textureStartY       テクスチャの開始地点Y
     * @param textureFinishWidth  テクスチャの終了地点X
     * @param textureFinishHeight テクスチャの終了地点Y
     * @param textureSizeX        テクスチャの横サイズ
     * @param textureSizeY        テクスチャの縦サイズ
     */
    public static void drawTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY) {
        poseStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.setShaderTexture(0, location);
        fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        poseStack.method_22909();
    }

    /**
     * GUI上でテクスチャを着色して描画する
     *
     * @param location            テクスチャ
     * @param poseStack           PoseStack
     * @param x                   X
     * @param y                   Y
     * @param textureStartX       テクスチャの開始地点X
     * @param textureStartY       テクスチャの開始地点Y
     * @param textureFinishWidth  テクスチャの終了地点X
     * @param textureFinishHeight テクスチャの終了地点Y
     * @param color               色(SRGB)
     * @since 2.0
     */
    public static void drawColorTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, int color) {
        drawColorTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256, 256, color);
    }

    /**
     * GUI上でテクスチャを着色して描画する
     *
     * @param location            テクスチャ
     * @param poseStack           PoseStack
     * @param x                   X
     * @param y                   Y
     * @param textureStartX       テクスチャの開始地点X
     * @param textureStartY       テクスチャの開始地点Y
     * @param textureFinishWidth  テクスチャの終了地点X
     * @param textureFinishHeight テクスチャの終了地点Y
     * @param textureSizeX        テクスチャの横サイズ
     * @param textureSizeY        テクスチャの縦サイズ
     * @param color               色(SRGB)
     * @since 2.0
     */
    public static void drawColorTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY, int color) {
        float r = (float) FNColorUtil.getRed(color) / 255f;
        float g = (float) FNColorUtil.getGreen(color) / 255f;
        float b = (float) FNColorUtil.getBlue(color) / 255f;
        float a = (float) FNColorUtil.getAlpha(color) / 255f;
        poseStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(r, g, b, a);
        RenderSystem.setShaderTexture(0, location);
        fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void fBlit(class_4587 poseStack, float ix, float iy, float tsx, float tsy, float tw, float th, float tssx, float tssy) {
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        float x = ix;
        float y = ix + tw;
        float w = iy;
        float h = iy + th;
        float u1 = tsx / tssx;
        float u2 = (tsx + tw) / tssx;
        float v1 = tsy / tssy;
        float v2 = (tsy + th) / tssy;
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x, h, 0).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, y, h, 0).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, y, w, 0).method_22913(u2, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, x, w, 0).method_22913(u1, v1).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309(bufferBuilder);
    }

    /**
     * PoseStackを16分の１単位で移動する
     *
     * @param poseStack PoseStack
     * @param x         X
     * @param y         Y
     * @param z         Z
     */
    public static void poseTrans16(class_4587 poseStack, double x, double y, double z) {
        float pix = 1f / 16f;
        poseStack.method_22904(pix * x, pix * y, pix * z);
    }

    /**
     * PoseStackをすべてのスケールを設定する
     *
     * @param poseStack PoseStack
     * @param scale     すべてのスケール
     */
    public static void poseScaleAll(class_4587 poseStack, float scale) {
        poseStack.method_22905(scale, scale, scale);
    }

    /**
     * PoseStackの角度をそれぞれ設定する
     *
     * @param poseStack PoseStack
     * @param x         X角度
     * @param y         Y角度
     * @param z         Z角度
     */
    public static void poseRotateAll(class_4587 poseStack, float x, float y, float z) {
        poseRotateX(poseStack, x);
        poseRotateY(poseStack, y);
        poseRotateZ(poseStack, z);
    }

    /**
     * PoseStackのX角度を設定する
     *
     * @param poseStack PoseStack
     * @param angle     角度
     */
    public static void poseRotateX(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20703.method_23214(angle));
    }

    /**
     * PoseStackのY角度を設定する
     *
     * @param poseStack PoseStack
     * @param angle     角度
     */
    public static void poseRotateY(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20705.method_23214(angle));
    }

    /**
     * PoseStackのZ角度を設定する
     *
     * @param poseStack PoseStack
     * @param angle     角度
     */
    public static void poseRotateZ(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20707.method_23214(angle));
    }

    /**
     * PoseStackの方向のブロックステートに設定する
     *
     * @param poseStack PoseStack
     * @param state     角度
     * @param roted     回転ずれ
     */
    public static void poseRotateHorizontalState(class_4587 poseStack, class_2680 state, int roted) {
        class_2350 direction = state.method_11654(class_2741.field_12481);
        poseRotateDirection(poseStack, direction, roted);
    }

    /**
     * PoseStackをDirectionの方向にする
     *
     * @param poseStack PoseStack
     * @param direction 方向
     * @param roted     回転ずれ
     */
    public static void poseRotateDirection(class_4587 poseStack, class_2350 direction, int roted) {
        for (int i = 0; i < roted; i++) {
            direction = direction.method_10170();
        }
        if (direction == class_2350.field_11039) {
            poseRotateY(poseStack, 180);
            poseStack.method_22904(-1f, 0f, -1f);
        } else if (direction == class_2350.field_11043) {
            poseRotateY(poseStack, 90);
            poseStack.method_22904(-1f, 0f, 0f);
        } else if (direction == class_2350.field_11035) {
            poseRotateY(poseStack, 270);
            poseStack.method_22904(0f, 0f, -1f);
        }
    }

    /**
     * UUIDから取得したプレイヤーの顔スプライトを描画する
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param uuid              プレイヤーUUID
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param size              サイズ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     * @since 2.0
     */
    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8f;
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + class_3532.field_29849, pitch, yaw, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
    }

    /**
     * 名前から取得したプレイヤーの顔スプライトを描画する
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param name              プレイヤー名
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param size              サイズ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     * @since 2.0
     */
    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8f;
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + class_3532.field_29849, pitch, yaw, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
    }

    /**
     * UUIDから取得したプレイヤーの顔スプライトを両面に描画する
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param uuid              プレイヤーUUID
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param size              サイズ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     * @since 2.0
     */
    public static void renderPlayerFaceSpriteSides(class_4587 poseStack, class_4597 multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8f;
        renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + class_3532.field_29849, pitch, yaw, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x + 1f, y, z - (class_3532.field_29849 * 2), pitch, yaw + 180, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
    }

    /**
     * 名前から取得したプレイヤーの顔スプライトを両面に描画する
     *
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param name              プレイヤー名
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param size              サイズ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     * @since 2.0
     */
    public static void renderPlayerFaceSpriteSides(class_4587 poseStack, class_4597 multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8f;
        renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + class_3532.field_29849, pitch, yaw, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x + 1f, y, z - (class_3532.field_29849 * 2), pitch, yaw + 180, roll, size, size, 40f * sc, 8f * sc, 8f * sc, 8f * sc, 64f * sc, 64f * sc, combinedLightIn, combinedOverlayIn);
    }

    /**
     * テクスチャスプライトを描画する
     *
     * @param location          テクスチャ
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param w                 幅
     * @param h                 高さ
     * @param texStartX         テクスチャ開始X
     * @param texStartY         テクスチャ開始Y
     * @param texFinishX        テクスチャ終了X
     * @param texFinishY        テクスチャ終了Y
     * @param texSizeW          テクスチャサイズ幅
     * @param texSizeH          テクスチャサイズ高さ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     */
    public static void renderTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        renderColorTextureSprite(location, poseStack, multiBufferSource, x, y, z, 1f, 1f, 1f, 1f, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    /**
     * 着色してテクスチャスプライトを描画する
     *
     * @param location          テクスチャ
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param r                 赤色
     * @param g                 緑色
     * @param b                 青色
     * @param a                 透明度
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param w                 幅
     * @param h                 高さ
     * @param texStartX         テクスチャ開始X
     * @param texStartY         テクスチャ開始Y
     * @param texFinishX        テクスチャ終了X
     * @param texFinishY        テクスチャ終了Y
     * @param texSizeW          テクスチャサイズ幅
     * @param texSizeH          テクスチャサイズ高さ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     * @since 2.0
     */
    public static void renderColorTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float r, float g, float b, float a, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        poseStack.method_22904(x, y, z);
        poseRotateY(poseStack, yaw);
        poseRotateX(poseStack, pitch);
        poseRotateZ(poseStack, roll);
        class_4588 vc = multiBufferSource.getBuffer(class_1921.method_23028(location));
        float wst = texStartX / texSizeW;
        float wft = texFinishX / texSizeW + wst;
        float hst = texStartY / texSizeH;
        float hft = texFinishY / texSizeH + hst;
        class_4587.class_4665 pose = poseStack.method_23760();
        vertex(vc, pose, 0, 0, 0, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        vertex(vc, pose, w, 0, 0, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        vertex(vc, pose, w, h, 0, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        vertex(vc, pose, 0, h, 0, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        poseStack.method_22909();
    }


    /**
     * テクスチャスプライトを両面に描画する
     *
     * @param location          テクスチャ
     * @param poseStack         PoseStack
     * @param multiBufferSource MultiBufferSource
     * @param x                 X
     * @param y                 Y
     * @param z                 Z
     * @param pitch             角度pitch
     * @param yaw               角度yaw
     * @param roll              角度roll
     * @param w                 幅
     * @param h                 高さ
     * @param texStartX         テクスチャ開始X
     * @param texStartY         テクスチャ開始Y
     * @param texFinishX        テクスチャ終了X
     * @param texFinishY        テクスチャ終了Y
     * @param texSizeW          テクスチャサイズ幅
     * @param texSizeH          テクスチャサイズ高さ
     * @param combinedLightIn   CombinedLightIn
     * @param combinedOverlayIn CombinedOverlayIn
     */
    public static void renderTextureSpriteSides(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        renderTextureSprite(location, poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
        renderTextureSprite(location, poseStack, multiBufferSource, x + 1f, y, z - class_3532.field_29849, pitch, yaw + 180, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    private static void vertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.method_22918(pose.method_23761(), x, y, z).method_22915(r, g, b, a).method_22913(u, v).method_22922(combinedOverlayIn).method_22916(combinedLightIn).method_23763(pose.method_23762(), 0f, 0f, 0f).method_1344();
    }


    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, @NotNull class_1087 bakedModel, int combinedLight, int combinedOverlay) {
        Objects.requireNonNull(bakedModel);
        var bmr = mc.method_1541().method_3350();
        bmr.renderModel(poseStack.method_23760(), vertexConsumer, null, bakedModel, 1.0F, 1.0F, 1.0F, combinedLight, combinedOverlay);
    }

    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, @NotNull class_1087 bakedModel, int combinedLight, int combinedOverlay, int color) {
        Objects.requireNonNull(bakedModel);
        var bmr = mc.method_1541().method_3350();
        float r = (float) (color >> 16 & 255) / 255.0F;
        float g = (float) (color >> 8 & 255) / 255.0F;
        float b = (float) (color & 255) / 255.0F;
        bmr.renderModel(poseStack.method_23760(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }

    public static float getPartialTicks() {
        return mc.method_1493() ? mc.field_1741 : mc.method_1488();
    }

    public static void renderPlayerArm(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, int light) {
        if (mc.field_1724.method_5767()) return;
        boolean bl = arm != class_1306.field_6182;
        var pr = (class_1007) mc.method_1561().method_3953(mc.field_1724);
        RenderSystem.setShaderTexture(0, mc.field_1724.method_3117());
        if (bl) {
            pr.renderRightHand(poseStack, multiBufferSource, light, mc.field_1724);
        } else {
            pr.renderLeftHand(poseStack, multiBufferSource, light, mc.field_1724);
        }
    }

    public static void posePlayerArm(class_4587 poseStack, class_1306 arm, float swingProgress, float equipProgress) {
        boolean bl = arm != class_1306.field_6182;
        float h = bl ? 1.0F : -1.0F;
        float j = class_3532.method_15355(swingProgress);
        float k = -0.3F * class_3532.method_15374(j * class_3532.field_29844);
        float l = 0.4F * class_3532.method_15374(j * class_3532.field_29846);
        float m = -0.4F * class_3532.method_15374(swingProgress * class_3532.field_29844);

        poseStack.method_22904(h * (k + 0.64000005F), l + -0.6F + equipProgress * -0.6F, m + -0.71999997F);
        poseStack.method_22907(class_1160.field_20705.method_23214(h * 45.0F));
        float n = class_3532.method_15374(swingProgress * swingProgress * class_3532.field_29844);
        float o = class_3532.method_15374(j * class_3532.field_29844);
        poseStack.method_22907(class_1160.field_20705.method_23214(h * o * 70.0F));
        poseStack.method_22907(class_1160.field_20707.method_23214(h * n * -20.0F));
        poseStack.method_22904(h * -1.0F, 3.5999999046325684D, 3.5D);
        poseStack.method_22907(class_1160.field_20707.method_23214(h * 120.0F));
        poseStack.method_22907(class_1160.field_20703.method_23214(200.0F));
        poseStack.method_22907(class_1160.field_20705.method_23214(h * -135.0F));
        poseStack.method_22904(h * 5.6F, 0.0D, 0.0D);
    }

    public static void renderHandItem(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, class_1799 stack, int light) {
        boolean handFlg = arm == class_1306.field_6183;
        mc.method_1489().method_3233(mc.field_1724, stack, handFlg ? class_809.class_811.field_4322 : class_809.class_811.field_4321, !handFlg, poseStack, multiBufferSource, light);
    }

    public static void poseHandItem(class_4587 poseStack, class_1306 arm, float swingProgress, float equipProgress) {
        boolean handFlg = arm == class_1306.field_6183;
        float s = -0.4F * class_3532.method_15374(class_3532.method_15355(swingProgress) * class_3532.field_29844);
        float r = 0.2F * class_3532.method_15374(class_3532.method_15355(swingProgress) * class_3532.field_29846);
        float l = -0.2F * class_3532.method_15374(swingProgress * class_3532.field_29844);
        int t = handFlg ? 1 : -1;
        poseStack.method_22904((float) t * s, r, l);
        poseStack.method_22904((float) t * 0.56F, -0.52F + equipProgress * -0.6F, -0.7200000286102295D);
        float g = class_3532.method_15374(swingProgress * swingProgress * class_3532.field_29844);
        poseStack.method_22907(class_1160.field_20705.method_23214((float) t * (45.0F + g * -20.0F)));
        float h = class_3532.method_15374(class_3532.method_15355(swingProgress) * class_3532.field_29844);
        poseStack.method_22907(class_1160.field_20707.method_23214((float) t * h * -20.0F));
        poseStack.method_22907(class_1160.field_20703.method_23214(h * -80.0F));
        poseStack.method_22907(class_1160.field_20705.method_23214((float) t * -45.0F));
    }

    public static float getParSecond(long loopTime) {
        return (float) (System.currentTimeMillis() % loopTime) / (float) loopTime;
    }

    public static String getWidthString(String text, float maxWidth, String exit) {
        int wh = mc.field_1772.method_1727(text);
        if (maxWidth >= wh)
            return text;
        int exwh = mc.field_1772.method_1727(exit);
        StringBuilder sb = new StringBuilder();

        for (char c : text.toCharArray()) {
            sb.append(c);
            if (mc.field_1772.method_1727(sb.toString()) > maxWidth - exwh)
                break;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(exit);
        return sb.toString();
    }

    public static void noTransAndRotModelPart(Runnable runnable) {
        SKIP_TRANSANDROT_MODELPART = true;
        runnable.run();
        SKIP_TRANSANDROT_MODELPART = false;
    }

    public static void renderPlayerArmNoTransAndRot(class_4587 poseStack, class_4597 multiBufferSource, class_1306 arm, int light) {
        noTransAndRotModelPart(() -> renderPlayerArm(poseStack, multiBufferSource, arm, light));
    }
}