package dev.felnull.otyacraftengine.client.gui.screen.debug;

import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.BakedModelRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.IRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.ItemRenderTest;
import dev.felnull.otyacraftengine.client.model.OETestModels;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1802;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5244;

public class RenderTestScreen extends OEBaseScreen {
    private static final List<IRenderTest> renderTests = new ArrayList<>();
    private int currentTest;
    private long eqAll;
    private long lastTime = -1;
    private long rtAll;
    private int sampleCount;
    private int testCount = 1;
    private Motion motion = Motion.FIX;
    private class_1160 cameraPos = new class_1160(0, 0, 1);
    private class_1160 cameraRot = new class_1160();

    private class_342 countBox;

    public RenderTestScreen(@Nullable class_437 parent) {
        super(new class_2585("Render Test"), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new class_4185(3, field_22790 - 23, 100, 20, class_5244.field_24339, n -> mc.method_1507(getParentScreen())));
        this.method_37063(new class_4185(106, field_22790 - 23, 100, 20, new class_2585("Reset"), n -> reset()));

        this.countBox = this.method_37063(new class_342(mc.field_1772, 209, field_22790 - 23, 70, 20, new class_2585("Count")));
        this.countBox.method_1852(String.valueOf(testCount));
        this.countBox.method_1863(n -> {
            if (!n.isEmpty()) {
                try {
                    int val = Integer.parseInt(n);
                    if (val < 0) {
                        this.countBox.method_1852("0");
                    } else {
                        setCount(val);
                    }
                } catch (NumberFormatException e) {
                    this.countBox.method_1852("0");
                }
            } else {
                this.countBox.method_1852("0");
            }
        });

        this.method_37063(new class_4185(282, field_22790 - 23, 20, 20, new class_2585("-1"), n -> this.countBox.method_1852(String.valueOf(testCount - 1))));
        this.method_37063(new class_4185(305, field_22790 - 23, 20, 20, new class_2585("+1"), n -> this.countBox.method_1852(String.valueOf(testCount + 1))));

        this.method_37063(new class_4185(328, field_22790 - 23, 100, 20, new class_2585("Motion: " + motion.name()), n -> {
            motion = Motion.values()[(motion.ordinal() + 1) % Motion.values().length];
            n.method_25355(new class_2585("Motion: " + motion.name()));
        }));

        if (!renderTests.isEmpty()) {
            this.method_37063(new class_4185(field_22789 - 23, 3, 20, 20, new class_2585("->"), n -> {
                currentTest = (currentTest + 1) % renderTests.size();
                reset();
            }));
            this.method_37063(new class_4185(field_22789 - 46, 3, 20, 20, new class_2585("<-"), n -> {
                currentTest = (currentTest - 1) % renderTests.size();
                if (currentTest < 0)
                    currentTest = renderTests.size() - 1;
                reset();
            }));
        }

        reset();
    }

    private void setCount(int count) {
        testCount = count;
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int mx, int my, float f) {
        long rt = System.nanoTime() - lastTime;
        if (lastTime >= 0)
            rtAll += rt;

        this.method_25434(0);
        float sy = field_22790 - field_22790 / 4f;
        drawRelativeFill(poseStack, 0, 0, field_22789, sy, 0xFFFFFFFF);
        drawRelativeFill(poseStack, 0, 0, field_22789, sy - 1f, 0xFF000000);
        super.method_25394(poseStack, mx, my, f);

        if (renderTests.isEmpty()) return;

        class_4597.class_4598 buf = mc.method_22940().method_23000();

        long st = System.nanoTime();
        renderTest(poseStack, buf, f, testCount);
        long eq = System.nanoTime() - st;

        buf.method_22993();

        eqAll += eq;
        sampleCount++;
        float eqAvg = (float) eqAll / (float) sampleCount;
        float rtAvg = (float) rtAll / (float) (sampleCount - 1);

        drawTextBase(poseStack, mc.field_1770, 3f, sy, 0xFFFFFF);

        drawTextBase(poseStack, String.format("Rendering Time: %.3fms %06dns", eq / 1000000f, eq), 3f, sy + mc.field_1772.field_2000 + 1, 0xFFFFFF);
        drawTextBase(poseStack, String.format("Rendering Average Time: %.3fms %06dns", eqAvg / 1000000f, (int) eqAvg), 3f, sy + (mc.field_1772.field_2000 + 1) * 2, 0xFFFFFF);

        drawTextBase(poseStack, String.format("Return Time: %.3fms %06dns", rt / 1000000f, rt), 3f + field_22789 / 2f, sy + mc.field_1772.field_2000 + 1, 0xFFFFFF);
        drawTextBase(poseStack, String.format("Return Average Time: %.3fms %06dns", rtAvg / 1000000f, (int) rtAvg), 3f + field_22789 / 2f, sy + (mc.field_1772.field_2000 + 1) * 2, 0xFFFFFF);

        if (motion == Motion.MOTION) {
            var rv = SocketDebugService.getAngele(f);
            var pv = SocketDebugService.getPosition(f);
            drawTextBase(poseStack, String.format("Debug Motion:  Yaw: %s  Pitch: %s  Roll: %s  x: %s  y: %s  z: %s", rv.x(), rv.y(), rv.z(), pv.x(), pv.y(), pv.z()), 3f, sy + (mc.field_1772.field_2000 + 1) * 3, 0xFFFFFF);
        }

        lastTime = System.nanoTime();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (motion == Motion.FREE_LOOK) {
            float speed = 1;
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1894)) {
                cameraPos.method_4948(0, -speed, 0);
            }
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1881)) {
                cameraPos.method_4948(0, speed, 0);
            }
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1849)) {
                cameraPos.method_4948(speed, 0, 0);
            }
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1913)) {
                cameraPos.method_4948(-speed, 0, 0);
            }
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1867)) {
                cameraPos = new class_1160(0, 0, 1);
                cameraRot = new class_1160();
            }
        }
    }

    @Override
    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (motion == Motion.FREE_LOOK) {
            boolean l = i == 0;
            if (l)
                cameraRot.method_4948(-(float) g, (float) f, 0);
            else
                cameraPos.method_4948((float) f, (float) g, 0);
        }
        return super.method_25403(d, e, i, f, g);
    }

    @Override
    public boolean method_25401(double d, double e, double f) {
        if (motion == Motion.FREE_LOOK) {

            cameraPos.method_4948(0, 0, (float) f * (OEClientUtil.isKeyInput(mc.field_1690.field_1832) ? 0.5f : 1f));
            cameraPos.method_4949(cameraPos.method_4943(), cameraPos.method_4945(), Math.max(cameraPos.method_4947(), 1));
        }
        return super.method_25401(d, e, f);
    }

    private void reset() {
        eqAll = 0;
        sampleCount = 0;
        lastTime = -1;
        rtAll = 0;
    }

    private void renderTest(@NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, float f, int count) {
        float sy = field_22790 - field_22790 / 4f;

        poseStack.method_22903();

        if (motion != Motion.TRANSLATED && motion != Motion.ROTED && motion != Motion.BOTH) {
            double x = field_22789 / 2f;
            double y = sy / 2f;

            if (motion == Motion.FREE_LOOK) {
                x += cameraPos.method_4943() * cameraPos.method_4947();
                y += cameraPos.method_4945() * cameraPos.method_4947();


                poseStack.method_22904(x, y, 30);
                OERenderUtil.poseRotateAll(poseStack, cameraRot.method_4943(), cameraRot.method_4945(), cameraRot.method_4947());
                poseStack.method_22904(-x, -y, -30);
            }

            if (motion == Motion.MOTION) {
                var pv = SocketDebugService.getPosition(f);
                x += pv.x();
                y += pv.z();
                poseStack.method_22904(x, y, 30);
                var rv = SocketDebugService.getAngele(f);
                OERenderUtil.poseRotateY(poseStack, rv.x());
                //    OERenderUtil.poseRotateX(poseStack, rv.y());
                OERenderUtil.poseRotateZ(poseStack, rv.z());
                poseStack.method_22904(-x, -y, -30);
            }

            poseStack.method_22904(x, y, 1050.0D);
            poseStack.method_22905(1, 1, -1);
            poseStack.method_22904(0.0D, 0.0D, 1000);
            poseStack.method_22905((float) 30, (float) -30, (float) 30);

            if (motion == Motion.FREE_LOOK)
                OERenderUtil.poseScaleAll(poseStack, cameraPos.method_4947());
        }

        for (int i = 0; i < count; i++) {
            float sp = OERenderUtil.getParSecond(5000) + (1f / count) * i;
            if (sp > 1)
                sp -= 1;
            poseStack.method_22903();

            double x = field_22789 / 2f;
            double y = sy / 2f;

            if (motion == Motion.TRANSLATED || motion == Motion.BOTH) {
                float par = (float) (sp * Math.toRadians(360));
                x += Math.sin(par) * ((field_22789 / 2f) - 30);
                y += Math.sin(2 * par) * ((sy / 2) - 30);
            }

            if (motion == Motion.ROTED || motion == Motion.BOTH) {
                poseStack.method_22904(x, y, 30);
                OERenderUtil.poseRotateX(poseStack, sp * 360);
                OERenderUtil.poseRotateY(poseStack, sp * 360);
                OERenderUtil.poseRotateZ(poseStack, sp * 360);
                poseStack.method_22904(-x, -y, -30);
            }

            if (motion == Motion.TRANSLATED || motion == Motion.ROTED || motion == Motion.BOTH) {
                poseStack.method_22904(x, y, 1050.0D);
                poseStack.method_22905(1, 1, -1);
                poseStack.method_22904(0.0D, 0.0D, 1000);
                poseStack.method_22905((float) 30, (float) -30, (float) 30);
            }

            renderTest(poseStack, multiBufferSource, f);

            poseStack.method_22909();
        }

        poseStack.method_22909();
    }

    private void renderTest(@NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, float f) {
        var rt = renderTests.get(currentTest);
        if (rt != null)
            rt.renderTest(poseStack, multiBufferSource, f);
    }

    public static void addRenderTest(IRenderTest renderTest) {
        renderTests.add(renderTest);
    }

    public static void fInit() {
        // for (Item item : Registry.ITEM) {
        //      addRenderTest(new ItemRenderTest(item));
        //  }
        //10000
        addRenderTest(new BakedModelRenderTest(new class_2960(OtyacraftEngine.MODID, "block/test_model")));//23.5 26.7
        addRenderTest(new BakedModelRenderTest(new class_2960(OtyacraftEngine.MODID, "item/test_item_kame")));//144.5*10 32.6*10
        addRenderTest(new ItemRenderTest(class_1802.field_8279));//44.2 56.5
        addRenderTest(new ItemRenderTest(class_1802.field_8773));//13.0 17.7


        addRenderTest(new BakedModelRenderTest(OETestModels.ORIGIN));
        addRenderTest(new BakedModelRenderTest(OETestModels.XYZ_AXIS));
    }

    private static enum Motion {
        FIX, TRANSLATED, ROTED, BOTH, FREE_LOOK, MOTION;
    }
}
