/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.loader;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.fnjl.util.FNURLUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class PlayerInfoManager {
    private static final PlayerInfoManager INSTANCE = new PlayerInfoManager();
    private static final Gson GSON = new Gson();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Map<UUID, String> NAME_BY_UUID_CASH = new HashMap<UUID, String>();
    private final List<UUID> LOADING_NAME_BY_UUID = new ArrayList<UUID>();
    private final Map<String, UUID> UUID_BY_NAME_CASH = new HashMap<String, UUID>();
    private final List<String> LOADING_UUID_BY_NAME = new ArrayList<String>();

    public static PlayerInfoManager getInstance() {
        return INSTANCE;
    }

    public Optional<UUID> getUUIDByName(@NotNull String name) {
        if (this.UUID_BY_NAME_CASH.containsKey(name)) {
            return Optional.ofNullable(this.UUID_BY_NAME_CASH.get(name));
        }
        if (this.LOADING_UUID_BY_NAME.contains(name)) {
            return Optional.empty();
        }
        this.LOADING_UUID_BY_NAME.add(name);
        this.load(String.format("https://api.mojang.com/users/profiles/minecraft/%s", name), n -> {
            if (n != null) {
                UUID uuid = null;
                try {
                    JsonObject jo = (JsonObject)GSON.fromJson(n, JsonObject.class);
                    uuid = FNStringUtil.fromNoHyphenStringToUUID((String)jo.get("id").getAsString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.UUID_BY_NAME_CASH.put(name, uuid);
            } else {
                this.UUID_BY_NAME_CASH.put(name, null);
            }
            this.LOADING_UUID_BY_NAME.remove(name);
        });
        return Optional.empty();
    }

    public Optional<String> getNameByUUID(@NotNull UUID uuid) {
        if (this.NAME_BY_UUID_CASH.containsKey(uuid)) {
            return Optional.ofNullable(this.NAME_BY_UUID_CASH.get(uuid));
        }
        if (this.LOADING_NAME_BY_UUID.contains(uuid)) {
            return Optional.empty();
        }
        this.LOADING_NAME_BY_UUID.add(uuid);
        this.load(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s", uuid), n -> {
            if (n != null) {
                String name = null;
                try {
                    JsonObject jo = (JsonObject)GSON.fromJson(n, JsonObject.class);
                    name = jo.get("name").getAsString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.NAME_BY_UUID_CASH.put(uuid, name);
            } else {
                this.NAME_BY_UUID_CASH.put(uuid, null);
            }
            this.LOADING_NAME_BY_UUID.remove(uuid);
        });
        return Optional.empty();
    }

    public Future<String> load(String url, Consumer<String> ret) {
        return this.executorService.submit(() -> {
            String res = null;
            try {
                res = FNURLUtil.getResponse((URL)new URL(url));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret.accept(res);
            return res;
        });
    }

    public void reload() {
        this.executorService.shutdown();
        this.executorService.shutdownNow();
        this.NAME_BY_UUID_CASH.clear();
        this.LOADING_NAME_BY_UUID.clear();
        this.UUID_BY_NAME_CASH.clear();
        this.LOADING_UUID_BY_NAME.clear();
        this.executorService = Executors.newSingleThreadExecutor();
    }
}

