package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import dev.felnull.otyacraftengine.client.gui.subtitle.IDynamicSubtitle;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.util.OELangUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import var;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2631;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_359;
import net.minecraft.class_3675;

public class OEClientUtil {
    protected static final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<>();
    private static final class_310 mc = class_310.method_1551();

    /**
     * "
     * クライアントでプレイヤープロフィールを取得する
     *
     * @param name プレイヤー名
     * @return プロフィール
     */
    public static GameProfile getClientPlayerProfile(String name) {
        if (PLAYER_PROFILES.containsKey(name))
            return PLAYER_PROFILES.get(name);

        GameProfile gp = new GameProfile(null, name);
        PLAYER_PROFILES.put(name, gp);
        class_2631.method_11335(gp, n -> PLAYER_PROFILES.put(name, n));
        return gp;
    }

    /**
     * キーが押されているか
     *
     * @param keyCode キーコード
     * @return 押されているか
     */
    public static boolean isKeyInput(int keyCode) {
        if (keyCode < GLFW.GLFW_MOUSE_BUTTON_1)
            return false;

        long winID = class_310.method_1551().method_22683().method_4490();

        if (keyCode <= GLFW.GLFW_MOUSE_BUTTON_8)
            return GLFW.glfwGetMouseButton(winID, keyCode) == 1;

        return class_3675.method_15987(winID, keyCode);
    }

    /**
     * キーが押されているか
     *
     * @param keyCode キー
     * @return 押されているか
     */
    public static boolean isKeyInput(class_304 keyCode) {
        return isKeyInput(OEClientExpectPlatform.getKey(keyCode).method_1444());
    }

    /**
     * プレイヤーをUUIDから取得
     *
     * @param uuid プレイヤーUUID
     * @return 名前
     */
    public static Optional<String> getPlayerNameByUUID(@NotNull UUID uuid) {
        if (mc.field_1724 != null) {
            var pi = mc.field_1724.field_3944.method_2871(uuid);
            if (pi != null)
                return Optional.of(pi.getProfile().getName());
        }
        return PlayerInfoManager.getInstance().getNameByUUID(uuid);
    }

    /**
     * プレイヤーのUUIDを名前から取得
     *
     * @param name プレイヤー名
     * @return uuid
     */
    public static Optional<UUID> getPlayerUUIDByName(@NotNull String name) {
        var pi = mc.field_1724.field_3944.method_2874(name);
        if (pi != null)
            return Optional.of(pi.getProfile().getId());
        return PlayerInfoManager.getInstance().getUUIDByName(name);
    }

    /**
     * GoogleLangCodeから言語に変換
     *
     * @param googleCode GoogleLangCode
     * @return 言語
     */
    public static class_1077 getLanguageByGoogleCode(String googleCode) {
        var str = OELangUtil.getLangIdByGoogleCode(googleCode);
        if (str.isPresent())
            return mc.method_1526().method_4668(str.get());

        for (class_1077 language : mc.method_1526().method_4665()) {
            if (language.getCode().split("_")[0].equals(googleCode))
                return language;
        }

        return mc.method_1526().method_4668(class_1076.field_32971);
    }

    /**
     * 言語からGoogleLangCodeへ変換
     *
     * @param language 言語
     * @return GoogleLangCode
     */
    public static String getGoogleCodeByLanguage(class_1077 language) {
        var lng = OELangUtil.getGoogleCodeByLangId(language.getCode());
        if (lng.isPresent())
            return lng.get();

        String name = language.getCode().split("_")[0];
        for (String lang : OELangUtil.googleLangCodes) {
            if (lang.equals(name))
                return lang;
        }

        return "en";
    }

    /**
     * 字幕を追加
     *
     * @param subtitle  字幕
     * @param duplicate 　複製可能か
     */
    public static void addSubtitle(class_359.class_360 subtitle, boolean duplicate) {
        var subs = mc.field_1705.field_2027.field_2183;
        if (!duplicate) {
            for (class_359.class_360 sub : subs) {
                if (sub.method_1960().equals(subtitle.method_1960())) {
                    sub.method_1958(subtitle.method_1959());
                    ((IDynamicSubtitle) sub).setDynamicLocation(((IDynamicSubtitle) subtitle).getDynamicLocation());
                    return;
                }
            }
        }
        subs.add(subtitle);
    }

    @Nullable
    public static File[] openFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects) {
        var st = TinyFileDialogs.tinyfd_openFileDialog(title, defaultPath != null ? defaultPath.toString() : null, null, singleFilter, allowMultipleSelects);
        if (st == null) return null;
        try {
            if (allowMultipleSelects) {
                String[] sp = st.split("\\|");
                File[] fl = new File[sp.length];
                for (int i = 0; i < sp.length; i++) {
                    fl[i] = new File(sp[i]);
                }
                return fl;
            } else {
                return new File[]{new File(st)};
            }
        } catch (Exception ex) {
            return null;
        }
    }
}
