package dev.felnull.otyacraftengine.client.gui.screen.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.debug.MotionDebug;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.gui.components.BetterEditBox;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.gui.components.SwitchButton;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OEScreenUtil;
import dev.felnull.otyacraftengine.mixin.client.ScreenAccessor;
import dev.felnull.otyacraftengine.util.OEPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import var;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1160;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MotionDebugScreen extends OEBaseScreen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final SimpleDateFormat saveDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final class_1160 lastSocketRotation = new class_1160();
    private static boolean enableVisible = true;
    public static boolean pause;
    private static boolean socketRotationFixX = true;
    private static boolean socketRotationFixY = true;
    private static boolean socketRotationFixZ = true;
    private static boolean enableEdit = true;
    private class_4185 editTypeButton;
    private SwitchButton enableEditSwitch;
    private BetterEditBox xEditBox;
    private BetterEditBox yEditBox;
    private BetterEditBox zEditBox;
    private MotionListWidget motionListWidget;
    private class_4185 startButton;
    private class_4185 stopButton;
    private BetterEditBox motionSpeedEditBox;
    private BetterEditBox ratioEditBox;

    public MotionDebugScreen(@Nullable class_437 parent) {
        super(new class_2585("Motion Debug"), parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        var vib = method_37063(new class_4185(field_22789 - 13, 3, 10, 10, new class_2585("I"), this::toggleEnableVisible));


        int st = 3 + mc.field_1772.field_2000 * 6 + 2;
        var etsw = method_37063(new SwitchButton(3, st, new class_2585("Enable temporary Motion"), n -> getMotionDebug().setEnableTemporary(n.isEnable()), true));
        etsw.setEnable(getMotionDebug().isEnableTemporary());

        xEditBox = method_37063(new BetterEditBox(123, st, 50, 12, xEditBox, new class_2585("x")));
        yEditBox = method_37063(new BetterEditBox(176, st, 50, 12, yEditBox, new class_2585("y")));
        zEditBox = method_37063(new BetterEditBox(229, st, 50, 12, zEditBox, new class_2585("z")));

        Predicate<String> fpr = n -> {
            try {
                Float.parseFloat(n);
                return true;
            } catch (Exception ignored) {
            }
            return n.isEmpty();
        };

        xEditBox.method_1890(fpr);
        yEditBox.method_1890(fpr);
        zEditBox.method_1890(fpr);

        method_37063(new class_4185(123, st + 15, 50, 20, new class_2585("Input"), n -> {
            var cm = getMotion();
            xEditBox.method_1852(String.valueOf(cm.x()));
            yEditBox.method_1852(String.valueOf(cm.y()));
            zEditBox.method_1852(String.valueOf(cm.z()));
        }));

        method_37063(new class_4185(176, st + 15, 50, 20, new class_2585("Output"), n -> {
            if (!xEditBox.method_1882().isEmpty() && !yEditBox.method_1882().isEmpty() && !zEditBox.method_1882().isEmpty()) {
                try {
                    float x = Float.parseFloat(xEditBox.method_1882());
                    float y = Float.parseFloat(yEditBox.method_1882());
                    float z = Float.parseFloat(zEditBox.method_1882());
                    setMotion(x, y, z);
                } catch (Exception ignored) {
                }
            }
        }));

        method_37063(new class_4185(229, st + 15, 50, 20, new class_2585("Copy"), n -> {
            if (!xEditBox.method_1882().isEmpty() && !yEditBox.method_1882().isEmpty() && !zEditBox.method_1882().isEmpty())
                mc.field_1774.method_1455(String.format("%sf, %sf, %sf", xEditBox.method_1882(), yEditBox.method_1882(), zEditBox.method_1882()));
        }));

        method_37063(new class_4185(123, st + 15 + 23, 50, 20, new class_2585("All Copy"), n -> {
            var p = getMotionDebug().createPoint();
            var pos = p.getPosition();
            var rot = p.getRotation();
            var ang = rot.angle();
            var ori = rot.origin();
            var res = rot.reset();
            mc.field_1774.method_1455(String.format("%sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %s, %s, %s", pos.x(), pos.y(), pos.z(), ang.x(), ang.y(), ang.z(), ori.x(), ori.y(), ori.z(), res.getLeft(), res.getMiddle(), res.getLeft()));
        }));

        method_37063(new class_4185(123 + 53, st + 15 + 23, 50, 20, new class_2585("All Paste"), n -> {
            parseAll(mc.field_1774.method_1460());
        }));

        motionListWidget = method_37063(new MotionListWidget(field_22789 - 3 - 120, st - 20, 120, 50, 5, getMotionDebug().getPoints(), (widget, item) -> {
            var e = motionListWidget.getSelectedEntry();
            if (e != null)
                getMotionDebug().setPoint(e);
        }, motionListWidget));

        method_37063(new class_4185(field_22789 - 3 - 120, st + 50 + 3 - 20, 27, 20, new class_2585("Add"), n -> addPoint()));

        method_37063(new class_4185(field_22789 - 3 - 120 + 30, st + 50 + 3 - 20, 27, 20, new class_2585("Del"), n -> {
            var e = motionListWidget.getSelectedEntry();
            if (e != null) {
                int num = motionListWidget.getSelectedEntryIndex();
                getMotionDebug().getPoints().remove(num);
                motionListWidget.setSelectedEntry(num - 1);
            }
        }));

        method_37063(new class_4185(field_22789 - 3 - 120 + 60, st + 50 + 3 - 20, 27, 20, new class_2585("Set"), n -> {
            int num = motionListWidget.getSelectedEntryIndex();
            getMotionDebug().getPoints().set(num, getMotionDebug().createPoint());
            motionListWidget.setSelectedEntry(num);
        }));

        method_37063(new class_4185(field_22789 - 3 - 120 + 90, st + 50 + 3 - 20, 27, 20, new class_2585("Inj"), n -> {
            var e = motionListWidget.getSelectedEntry();
            if (e != null) {
                var ne = getMotionDebug().createPoint();
                int ei = motionListWidget.getSelectedEntryIndex();
                if (ei - 1 >= getMotionDebug().getPoints().size()) {
                    getMotionDebug().getPoints().add(ne);
                    motionListWidget.setSelectedEntry(getMotionDebug().getPoints().size() - 1);
                } else {
                    getMotionDebug().getPoints().add(ei + 1, ne);
                    motionListWidget.setSelectedEntry(ei + 1);
                }
                getMotionDebug().setRotationReset(false, false, false);
            }
        }));

        method_37063(new class_4185(field_22789 - 3 - 120, st + 50 + 3 - 20 + 23, 27, 20, new class_2585("Output"), n -> {
            if (getMotionDebug().getPoints().isEmpty()) return;
            var pt = OEPaths.getClientOEFolderPath().resolve("debug").resolve("motion");
            pt.toFile().mkdirs();
            var motion = getMotionDebug().createMotion();
            var jo = motion.toJson();
            try (Writer writer = new FileWriter(pt.resolve(saveDateFormat.format(new Date()) + ".json").toFile())) {
                GSON.toJson(jo, writer);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }));

        method_37063(new class_4185(field_22789 - 3 - 120 + 30, st + 50 + 3 - 20 + 23, 27, 20, new class_2585("Input"), n -> {
            var files = OEClientUtil.openFileChooser(null, OEPaths.getClientOEFolderPath(), null, false);
            loadJson(files);
        }));

        startButton = method_37063(new class_4185(field_22789 - 3 - 120 + 60, st + 50 + 3 - 20 + 23, 27, 20, new class_2585("Start"), n -> {
            n.field_22763 = false;
            stopButton.field_22763 = true;
            try {
                var str = motionSpeedEditBox.method_1882();
                long val = str.isEmpty() ? 3000 : Math.max(Long.parseLong(str), 1);
                getMotionDebug().startMotion(val);
            } catch (NumberFormatException ignored) {
            }
        }));
        startButton.field_22763 = !getMotionDebug().isMotionPlaying();


        stopButton = method_37063(new class_4185(field_22789 - 3 - 120 + 90, st + 50 + 3 - 20 + 23, 27, 20, new class_2585("Stop"), n -> {
            n.field_22763 = false;
            startButton.field_22763 = true;
            getMotionDebug().stopMotion();
        }));
        stopButton.field_22763 = getMotionDebug().isMotionPlaying();


        motionSpeedEditBox = method_37063(new BetterEditBox(field_22789 - 3 - 120, st + 50 + 3 - 20 + 23 + 23, 120, 12, motionSpeedEditBox, new class_2585("Motion Speed")));
        motionSpeedEditBox.method_1890(fpr);

        ratioEditBox = method_37063(new BetterEditBox(field_22789 - 3 - 120, st + 50 + 3 - 20 + 23 + 23 + 20, 50, 12, ratioEditBox, new class_2585("Ratio")));
        ratioEditBox.method_1890(fpr);
        ratioEditBox.method_1852(String.valueOf(getMotionDebug().getRatio()));
        ratioEditBox.method_1863(n -> {
            try {
                float r = ratioEditBox.method_1882().isEmpty() ? 1f : Float.parseFloat(ratioEditBox.method_1882());
                getMotionDebug().setRatio(r);
            } catch (NumberFormatException ignored) {
            }
        });

        st += 17;

        var tsw = method_37063(new SwitchButton(3, st, new class_2585("Edit temporary Motion"), n -> getMotionDebug().setEditTemporary(n.isEnable()), true));
        tsw.setEnable(getMotionDebug().isEditTemporary());
        st += 15;

        editTypeButton = method_37063(new class_4185(3, st, 120, 20, new class_2585(getMotionDebug().getEditType().name()), n -> setNextEditType()));
        st += 24;

        method_37063(new class_4185(3, st, 120, 20, new class_2585("Reset"), n -> getMotionDebug().reset()));
        st += 24;

        enableEditSwitch = method_37063(new SwitchButton(3, st, new class_2585("Enable Edit"), n -> enableEdit = n.isEnable(), true));
        enableEditSwitch.setEnable(enableEdit);
        st += 17;

        var srswfx = method_37063(new SwitchButton(3, st, new class_2585("Socket Rotation Fix X"), n -> socketRotationFixX = n.isEnable(), true));
        srswfx.setEnable(socketRotationFixX);
        st += 17;

        var srswfy = method_37063(new SwitchButton(3, st, new class_2585("Socket Rotation Fix Y"), n -> socketRotationFixY = n.isEnable(), true));
        srswfy.setEnable(socketRotationFixY);
        st += 17;

        var srswfz = method_37063(new SwitchButton(3, st, new class_2585("Socket Rotation Fix Z"), n -> socketRotationFixZ = n.isEnable(), true));
        srswfz.setEnable(socketRotationFixZ);
        st += 15;

        method_37063(new class_4185(3, st, 40, 20, new class_2585("Reset X"), n -> {
            var o = getMotionDebug().getRotation().reset();
            getMotionDebug().setRotationReset(true, o.getMiddle(), o.getRight());
            var oa = getMotionDebug().getRotation().angle();
            getMotionDebug().setRotationAngle(new class_1160(oa.x() % 360, oa.y(), oa.z()));
        }));

        method_37063(new class_4185(3 + 40 + 3, st, 40, 20, new class_2585("Reset Y"), n -> {
            var o = getMotionDebug().getRotation().reset();
            getMotionDebug().setRotationReset(o.getLeft(), true, o.getRight());
            var oa = getMotionDebug().getRotation().angle();
            getMotionDebug().setRotationAngle(new class_1160(oa.x(), oa.y() % 360, oa.z()));
        }));

        method_37063(new class_4185(3 + 40 + 3 + 3 + 40, st, 40, 20, new class_2585("Reset Z"), n -> {
            var o = getMotionDebug().getRotation().reset();
            getMotionDebug().setRotationReset(o.getLeft(), o.getMiddle(), true);
            var oa = getMotionDebug().getRotation().angle();
            getMotionDebug().setRotationAngle(new class_1160(oa.x(), oa.y(), oa.z() % 360));
        }));

        st += 24;

        var fosw = method_37063(new SwitchButton(3, st, new class_2585("Fix Origin"), n -> getMotionDebug().setFixOrigin(n.isEnable()), true));
        fosw.setEnable(getMotionDebug().isFixOrigin());
        st += 17;

        var sosw = method_37063(new SwitchButton(3, st, new class_2585("Show Origin"), n -> getMotionDebug().setShowOrigin(n.isEnable()), true));
        sosw.setEnable(getMotionDebug().isShowOrigin());

        var sca = (ScreenAccessor) this;
        sca.getRenderables().forEach(n -> {
            if (n == vib) return;
            if (n instanceof AbstractWidget w)
                w.visible = enableVisible;
        });
    }

    private void parseAll(String text) {
        if (text == null || text.isEmpty()) return;
        text = text.replace(" ", "");
        var str = text.split(",");
        try {
            float[] f = new float[9];
            for (int i = 0; i < f.length; i++) {
                f[i] = parseFloat(str[i]);
            }
            boolean[] b = new boolean[3];
            for (int i = 0; i < b.length; i++) {
                b[i] = Boolean.parseBoolean(str[f.length + i]);
            }
            getMotionDebug().setPosition(new class_1160(f[0], f[1], f[2]));
            getMotionDebug().setRotationAngle(new class_1160(f[3], f[4], f[5]));
            getMotionDebug().setRotationOrigin(new class_1160(f[6], f[7], f[8]), true);
            getMotionDebug().setRotationReset(b[0], b[1], b[2]);
        } catch (Exception ignored) {
        }
//        mc.keyboardHandler.setClipboard(String.format("%sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %s, %s, %s", pos.x(), pos.y(), pos.z(), ang.x(), ang.y(), ang.z(), ori.x(), ori.y(), ori.z(), res.getLeft(), res.getMiddle(), res.getLeft()));
    }

    private float parseFloat(String text) {
        try {
            text = text.replace("f", "");
            return Float.parseFloat(text);
        } catch (NumberFormatException ignored) {
        }
        return 0f;
    }

    protected void loadJson(File[] files) {
        if (files == null || files.length != 1) return;
        var fil = files[0];
        JsonObject jo = null;

        try (Reader reader = new FileReader(fil)) {
            jo = GSON.fromJson(reader, JsonObject.class);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        if (jo == null) return;
        getMotionDebug().setMotion(Motion.of(jo));
        motionListWidget.setSelectedEntry(0);
    }

    public void setNextEditType() {
        var et = getMotionDebug().getEditType();
        getMotionDebug().setEditType(MotionDebug.EditType.values()[(et.ordinal() + 1) % MotionDebug.EditType.values().length]);
        editTypeButton.method_25355(new class_2585(getMotionDebug().getEditType().name()));
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (isHoveredWidget((float) OEClientUtil.getMouseX(), (float) OEClientUtil.getMouseY()))
            return super.method_25404(i, j, k);

        if (i == GLFW.GLFW_KEY_R) {
            setNextEditType();
            return true;
        } else if (i == GLFW.GLFW_KEY_W) {
            enableEdit = !enableEdit;
            enableEditSwitch.setEnable(enableEdit);
            return true;
        } else if (i == GLFW.GLFW_KEY_Y) {
            toggleEnableVisible(null);
            return true;
        } else if (i == GLFW.GLFW_KEY_A) {
            addPoint();
            return true;
        }

        if (enableEdit) {
            boolean sflg = OEClientUtil.isKeyInput(mc.field_1690.field_1832);

            if (i == GLFW.GLFW_KEY_LEFT) {
                addMotion(0, -1, 0);
                return true;
            } else if (i == GLFW.GLFW_KEY_RIGHT) {
                addMotion(0, 1, 0);
                return true;
            } else if (i == GLFW.GLFW_KEY_UP) {
                if (sflg)
                    addMotion(0, 0, -1);
                else
                    addMotion(-1, 0, 0);
                return true;
            } else if (i == GLFW.GLFW_KEY_DOWN) {
                if (sflg)
                    addMotion(0, 0, 1);
                else
                    addMotion(1, 0, 0);
                return true;
            }
        }
        return super.method_25404(i, j, k);
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int x, int y, float f) {
        if (enableVisible)
            this.method_25420(poseStack);
        super.method_25394(poseStack, x, y, f);

        drawTextBase(poseStack, mc.field_1770, 3, 3, 0xFFFFFF);
        drawTextBase(poseStack, "Motion Point - " + createMotionText(getMotionDebug().getPosition(), getMotionDebug().getRotation().angle(), getMotionDebug().getRotation().origin()), 3, 3 + mc.field_1772.field_2000, 0xFFFFFF);
        var reset = getMotionDebug().getRotation().reset();
        drawTextBase(poseStack, String.format("Reset: [X: %s, Y: %s, Z: %s]", reset.getLeft() ? "T" : "F", reset.getMiddle() ? "T" : "F", reset.getRight() ? "T" : "F"), 3, 3 + mc.field_1772.field_2000 * 2, 0xFFFFFF);
        drawTextBase(poseStack, "Temporary - " + createMotionText(getMotionDebug().getTemporaryPosition(), getMotionDebug().getTemporaryRotation().angle(), getMotionDebug().getTemporaryRotation().origin()), 3, 3 + mc.field_1772.field_2000 * 3, 0xFFFFFF);
        drawTextBase(poseStack, "Sensitivity: " + getMotionDebug().getSensitivity(), 3, 3 + mc.field_1772.field_2000 * 4, 0xFFFFFF);
        var spos = SocketDebugService.getPosition(f);
        var srot = SocketDebugService.getAngele(f);
        drawTextBase(poseStack, !SocketDebugService.isConnected() ? "Socket - Not connected" : String.format("Socket - Pos: [X: %s  Y: %s  Z: %s], Rot: [X: %s, Y: %s, Z: %s]", (int) spos.x(), (int) spos.y(), (int) spos.z(), (int) srot.x(), (int) srot.y(), (int) srot.z()), 3, 3 + mc.field_1772.field_2000 * 5, 0xFFFFFF);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (!enableEdit) return;
        var sr = SocketDebugService.getAngele(0);

        var sa = new class_1160(lastSocketRotation.method_4943() - sr.x(), lastSocketRotation.method_4945() - sr.y(), lastSocketRotation.method_4947() - sr.z());
        float vx = 0;
        float vy = 0;
        float vz = 0;

        if (!socketRotationFixX)
            vx = sa.y();
        if (!socketRotationFixY)
            vy = -sa.x();
        if (!socketRotationFixZ)
            vz = sa.z();

        getMotionDebug().addRotationAngle(vx, vy, vz);
        lastSocketRotation.method_4949(sr.x(), sr.y(), sr.z());
    }


    @Override
    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (!isHoveredWidget((float) d, (float) e) && enableEdit) {
            boolean l = i == 0;
            if (l) {
                addMotion((float) g, (float) f, 0);
            } else {
                addMotion(0, (float) f, (float) g);
            }
        }
        return super.method_25403(d, e, i, f, g);
    }

    private void toggleEnableVisible(class_4185 button) {
        ScreenAccessor accessor = (ScreenAccessor) this;
        enableVisible = !enableVisible;
        accessor.getRenderables().forEach(m -> {
            if (m == button) return;
            if (m instanceof class_339 w)
                w.field_22764 = enableVisible;
        });
    }

    private void addPoint() {
        var ne = getMotionDebug().createPoint();
        getMotionDebug().getPoints().add(ne);
        motionListWidget.setSelectedEntry(getMotionDebug().getPoints().size() - 1);
        getMotionDebug().setRotationReset(false, false, false);
    }

    @Override
    public boolean method_25401(double x, double y, double f) {
        if (!isHoveredWidget((float) x, (float) y)) {
            float v = getMotionDebug().getSensitivity();
            if (OEClientUtil.isKeyInput(mc.field_1690.field_1832))
                f *= 0.1f;
            v += (f * 0.1f);
            getMotionDebug().setSensitivity(Math.max(v, 0));
        }
        return super.method_25401(x, y, f);
    }

    private boolean isHoveredWidget(float x, float y) {
        if (!enableVisible) return false;

        return OEScreenUtil.getRenderableAbstractWidgets(this).stream().filter(n -> x >= n.field_22760 && y >= n.field_22761 && x < (n.field_22760 + n.method_25368()) && y < (double) (n.field_22761 + n.method_25364())).anyMatch(n -> true);
    }

    private void setMotion(float x, float y, float z) {
        switch (getMotionDebug().getEditType()) {
            case POSITION -> getMotionDebug().setPosition(new Vector3f(x, y, z));
            case ROTATION -> getMotionDebug().setRotationAngle(new Vector3f(x, y, z));
            case ROTATION_ORIGIN -> getMotionDebug().setRotationOrigin(new Vector3f(x, y, z));
        }
    }

    private class_1160 getMotion() {
        return switch (getMotionDebug().getEditType()) {
            case POSITION -> getMotionDebug().getPosition();
            case ROTATION -> getMotionDebug().getRotation().angle();
            case ROTATION_ORIGIN -> getMotionDebug().getRotation().origin();
        };
    }

    private void addMotion(float x, float y, float z) {
        float sc = getMotionDebug().getSensitivity();
        x *= sc;
        y *= sc;
        z *= sc;

        if (getMotionDebug().isEditTemporary()) {
            switch (getMotionDebug().getEditType()) {
                case POSITION -> getMotionDebug().addTemporaryPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                case ROTATION -> getMotionDebug().addTemporaryRotationAngle(-x, -y, -z);
                case ROTATION_ORIGIN -> getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
            }
        } else {
            switch (getMotionDebug().getEditType()) {
                case POSITION -> getMotionDebug().addPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                case ROTATION -> getMotionDebug().addRotationAngle(-x, -y, -z);
                case ROTATION_ORIGIN -> getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
            }
        }
    }

    private MotionDebug getMotionDebug() {
        return MotionDebug.getInstance();
    }

    private static String createMotionText(class_1160 pos, class_1160 angle, class_1160 origin) {
        return String.format("Pos: [X: %s  Y: %s  Z: %s], Angle: [X: %s, Y: %s, Z: %s], Origin: [X: %s, Y: %s, Z: %s]", pos.method_4943(), pos.method_4945(), pos.method_4947(), angle.method_4943(), angle.method_4945(), angle.method_4947(), origin.method_4943(), origin.method_4945(), origin.method_4947());
    }

    @Override
    public boolean method_25421() {
        return pause;
    }

    private static class MotionListWidget extends FixedListWidget<MotionPoint> {
        public MotionListWidget(int x, int y, int width, int height, int entryShowCount, @NotNull List<MotionPoint> entryList, @Nullable PressEntry<MotionPoint> onPressEntry, MotionListWidget old) {
            super(x, y, width, height, new class_2585("Motion List"), entryShowCount, entryList, MotionPoint::getText, onPressEntry, true, old);
        }
    }
}
