/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import dev.felnull.otyacraftengine.client.gui.subtitle.IDynamicSubtitle;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import dev.felnull.otyacraftengine.util.OELangUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1077;
import net.minecraft.class_2631;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_359;
import net.minecraft.class_3675;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class OEClientUtil {
    protected static final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<String, GameProfile>();
    private static final class_310 mc = class_310.method_1551();

    public static GameProfile getClientPlayerProfile(String name) {
        if (PLAYER_PROFILES.containsKey(name)) {
            return PLAYER_PROFILES.get(name);
        }
        GameProfile gp = new GameProfile(null, name);
        PLAYER_PROFILES.put(name, gp);
        class_2631.method_11335((GameProfile)gp, n -> PLAYER_PROFILES.put(name, (GameProfile)n));
        return gp;
    }

    public static boolean isKeyInput(int keyCode) {
        if (keyCode < 0) {
            return false;
        }
        long winID = class_310.method_1551().method_22683().method_4490();
        if (keyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)winID, (int)keyCode) == 1;
        }
        return class_3675.method_15987((long)winID, (int)keyCode);
    }

    public static boolean isKeyInput(class_304 keyCode) {
        return OEClientUtil.isKeyInput(OEClientExpectPlatform.getKey(keyCode).method_1444());
    }

    public static Optional<String> getPlayerNameByUUID(@NotNull UUID uuid) {
        class_640 pi;
        if (OEClientUtil.mc.field_1724 != null && (pi = OEClientUtil.mc.field_1724.field_3944.method_2871(uuid)) != null) {
            return Optional.of(pi.method_2966().getName());
        }
        return PlayerInfoManager.getInstance().getNameByUUID(uuid);
    }

    public static Optional<UUID> getPlayerUUIDByName(@NotNull String name) {
        class_640 pi = OEClientUtil.mc.field_1724.field_3944.method_2874(name);
        if (pi != null) {
            return Optional.of(pi.method_2966().getId());
        }
        return PlayerInfoManager.getInstance().getUUIDByName(name);
    }

    public static class_1077 getLanguageByGoogleCode(String googleCode) {
        Optional<String> str = OELangUtil.getLangIdByGoogleCode(googleCode);
        if (str.isPresent()) {
            return mc.method_1526().method_4668(str.get());
        }
        for (class_1077 language : mc.method_1526().method_4665()) {
            if (!language.getCode().split("_")[0].equals(googleCode)) continue;
            return language;
        }
        return mc.method_1526().method_4668("en_us");
    }

    public static String getGoogleCodeByLanguage(class_1077 language) {
        Optional<String> lng = OELangUtil.getGoogleCodeByLangId(language.getCode());
        if (lng.isPresent()) {
            return lng.get();
        }
        String name = language.getCode().split("_")[0];
        for (String lang : OELangUtil.googleLangCodes) {
            if (!lang.equals(name)) continue;
            return lang;
        }
        return "en";
    }

    public static void addSubtitle(class_359.class_360 subtitle, boolean duplicate) {
        List subs = OEClientUtil.mc.field_1705.field_2027.field_2183;
        if (!duplicate) {
            for (class_359.class_360 sub : subs) {
                if (!sub.method_1960().equals(subtitle.method_1960())) continue;
                sub.method_1958(subtitle.method_1959());
                ((IDynamicSubtitle)sub).setDynamicLocation(((IDynamicSubtitle)subtitle).getDynamicLocation());
                return;
            }
        }
        subs.add(subtitle);
    }

    @Nullable
    public static File[] openFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects) {
        String st = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), null, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
        if (st == null) {
            return null;
        }
        try {
            if (allowMultipleSelects) {
                String[] sp = st.split("\\|");
                File[] fl = new File[sp.length];
                for (int i = 0; i < sp.length; ++i) {
                    fl[i] = new File(sp[i]);
                }
                return fl;
            }
            return new File[]{new File(st)};
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static double getMouseX() {
        return OEClientUtil.mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
    }

    public static double getMouseY() {
        return OEClientUtil.mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
    }
}

