package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import net.minecraft.class_1160;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import var;

public class OEMath {
    public static MotionRotation add(MotionRotation rotation, MotionRotation rotation2) {
        var c = rotation.origin().copy();
        c.add(rotation2.origin());

        var a = rotation.angle().copy();
        a.add(rotation2.angle());

        return new MotionRotation(a, c, Triple.of(false, false, false));
    }

    @NotNull
    public static MotionRotation leap(float delta, @NotNull MotionRotation old, @NotNull MotionRotation current) {
        return new MotionRotation(OEMath.leapAngle(delta, old, current), leap(delta, old.origin(), current.origin()), Triple.of(false, false, false));
    }

    @NotNull
    public static class_1160 leap(float delta, @NotNull class_1160 old, @NotNull class_1160 current) {
        return new class_1160(class_3532.method_16439(delta, old.method_4943(), current.method_4943()), class_3532.method_16439(delta, old.method_4945(), current.method_4945()), class_3532.method_16439(delta, old.method_4947(), current.method_4947()));
    }

    @NotNull
    public static class_1160 leapAngle(float delta, @NotNull MotionRotation oldRotation, @NotNull MotionRotation currentRotation) {
        return leapAngle(delta, oldRotation.angle(), currentRotation.angle(), currentRotation.reset());
    }

    @NotNull
    public static class_1160 leapAngle(float delta, @NotNull class_1160 oldAngle, @NotNull class_1160 currentAngle, @NotNull Triple<Boolean, Boolean, Boolean> reset) {
        float x = leapAngleValue(delta, oldAngle.method_4943(), currentAngle.method_4943(), reset.getLeft());
        float y = leapAngleValue(delta, oldAngle.method_4945(), currentAngle.method_4945(), reset.getMiddle());
        float z = leapAngleValue(delta, oldAngle.method_4947(), currentAngle.method_4947(), reset.getRight());
        return new class_1160(x, y, z);
    }

    private static float leapAngleValue(float delta, float old, float current, boolean reset) {
        if (!reset) {
            return class_3532.method_16439(delta, old, current);
        } else {
            return class_3532.method_16439(delta, old, toNoResetAngle(old, current));
        }
    }

    private static float toNoResetAngle(float old, float val) {
        return old - (old % 360) + val;
    }
}
