package dev.felnull.otyacraftengine.client.event;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import org.jetbrains.annotations.NotNull;

public interface ClientEvent {
    Event<ChangeHandHeight> CHANGE_HAND_HEIGHT = EventFactory.createEventResult();
    Event<PoseHumanoidArm> POSE_HUMANOID_ARM = EventFactory.createEventResult();
    Event<PauseChange> INTEGRATED_SERVER_PAUSE = EventFactory.createLoop();
    Event<HandAttack> HAND_ATTACK = EventFactory.createEventResult();

    public interface ChangeHandHeight {
        EventResult changeHandHeight(class_1268 hand, class_1799 oldStack, class_1799 newStack);
    }

    public interface PoseHumanoidArm {
        EventResult poseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity);
    }

    public interface PauseChange {
        void onPauseChange(boolean paused);
    }

    public interface HandAttack {
        EventResult onHandAttack(@NotNull class_1799 itemStack);
    }
}
