/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.debug;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.model.OETestModels;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class MotionDebug {
    private static final MotionDebug INSTANCE = new MotionDebug();
    private final List<MotionPoint> points = new ArrayList<MotionPoint>();
    private final DebugOption option = new DebugOption();
    private class_1160 position = new class_1160();
    private MotionRotation rotation = new MotionRotation();
    private float ratio = 1.0f;
    private class_1160 temporaryPosition = new class_1160();
    private SimpleRotation temporaryRotation = new SimpleRotation();
    private Motion playMotion;
    private long cycleSpeed;

    @NotNull
    public static MotionDebug getInstance() {
        return INSTANCE;
    }

    @NotNull
    public EditType getEditType() {
        return this.option.editType;
    }

    public boolean isFixOrigin() {
        return this.option.fixOrigin;
    }

    public void setFixOrigin(boolean fix) {
        this.option.fixOrigin = fix;
    }

    public boolean isShowOrigin() {
        return this.option.showOrigin;
    }

    public void setShowOrigin(boolean show) {
        this.option.showOrigin = show;
    }

    public boolean isEnableTemporary() {
        return this.option.enableTemporary;
    }

    public boolean isEditTemporary() {
        return this.option.editTemporary;
    }

    public float getSensitivity() {
        return this.option.sensitivity;
    }

    public void setEditType(@NotNull EditType editType) {
        this.option.editType = editType;
    }

    public void setEnableTemporary(boolean enable) {
        this.option.enableTemporary = enable;
    }

    public void setEditTemporary(boolean editTemporary) {
        this.option.editTemporary = editTemporary;
    }

    public void setSensitivity(float sensitivity) {
        this.option.sensitivity = sensitivity;
    }

    public class_1160 getTemporaryPosition() {
        return this.temporaryPosition;
    }

    public SimpleRotation getTemporaryRotation() {
        return this.temporaryRotation;
    }

    public List<MotionPoint> getPoints() {
        return this.points;
    }

    public class_1160 getPosition() {
        return this.position;
    }

    public MotionRotation getRotation() {
        return this.rotation;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public void setPosition(class_1160 position) {
        this.position = position;
    }

    public void setRotation(MotionRotation rotation) {
        this.rotation = rotation;
    }

    public void setRotationAngle(class_1160 angle) {
        MotionRotation o = this.rotation.copy();
        this.setRotation(new MotionRotation(angle, o.origin(), o.reset()));
    }

    public void setRotationOrigin(class_1160 origin) {
        this.setRotationOrigin(origin, false);
    }

    public void setRotationOrigin(class_1160 origin, boolean force) {
        if (this.isFixOrigin() && !force) {
            return;
        }
        MotionRotation o = this.rotation.copy();
        this.setRotation(new MotionRotation(o.angle(), origin, o.reset()));
    }

    public void setTemporaryPosition(class_1160 temporaryPosition) {
        this.temporaryPosition = temporaryPosition;
    }

    public void setTemporaryRotation(SimpleRotation temporaryRotation) {
        this.temporaryRotation = temporaryRotation;
    }

    public void addPosition(float x, float y, float z) {
        class_1160 o = this.getPosition().method_23850();
        o.method_4948(x, y, z);
        this.setPosition(o);
    }

    public void addRotationAngle(float x, float y, float z) {
        class_1160 o = this.getRotation().angle().method_23850();
        o.method_4948(x, y, z);
        this.setRotation(new MotionRotation(o, this.getRotation().origin(), this.getRotation().reset()));
    }

    public void setRotationReset(boolean x, boolean y, boolean z) {
        this.setRotation(new MotionRotation(this.getRotation().angle(), this.getRotation().origin(), (Triple<Boolean, Boolean, Boolean>)Triple.of((Object)x, (Object)y, (Object)z)));
    }

    public void addRotationOrigin(float x, float y, float z) {
        if (this.isFixOrigin()) {
            return;
        }
        class_1160 o = this.getRotation().origin().method_23850();
        o.method_4948(x, y, z);
        this.setRotation(new MotionRotation(this.getRotation().angle(), o, this.getRotation().reset()));
    }

    public void addTemporaryPosition(float x, float y, float z) {
        class_1160 o = this.getTemporaryPosition().method_23850();
        o.method_4948(x, y, z);
        this.setTemporaryPosition(o);
    }

    public void addTemporaryRotationAngle(float x, float y, float z) {
        class_1160 o = this.getTemporaryRotation().angle().method_23850();
        o.method_4948(x, y, z);
        this.setTemporaryRotation(new SimpleRotation(o, this.getRotation().origin()));
    }

    public void addTemporaryRotationOrigin(float x, float y, float z) {
        if (this.isFixOrigin()) {
            return;
        }
        class_1160 o = this.getTemporaryRotation().origin().method_23850();
        o.method_4948(x, y, z);
        this.setTemporaryRotation(new SimpleRotation(this.getRotation().angle(), o));
    }

    public void reset() {
        if (this.isEditTemporary()) {
            this.setTemporaryPosition(new class_1160());
            this.setTemporaryRotation(new SimpleRotation());
        } else {
            this.setPosition(new class_1160());
            class_1160 or = this.getRotation().origin().method_23850();
            this.setRotation(new MotionRotation());
            if (this.isFixOrigin()) {
                this.setRotationOrigin(or, true);
            }
        }
    }

    public MotionPose getPose() {
        return new MotionPose(this.position, this.rotation);
    }

    public void pose(@NotNull class_4587 stack) {
        stack.method_22904((double)this.position.method_4943(), (double)this.position.method_4945(), (double)this.position.method_4947());
        this.rotation.pose(stack);
        if (this.isEnableTemporary()) {
            stack.method_22904((double)this.temporaryPosition.method_4943(), (double)this.temporaryPosition.method_4945(), (double)this.temporaryPosition.method_4947());
            this.temporaryRotation.pose(stack);
        }
    }

    public void poseDebug(@NotNull class_4587 stack) {
        if (this.playMotion == null) {
            this.pose(stack);
            return;
        }
        this.playMotion.pose(stack, OERenderUtil.getParSecond(this.cycleSpeed));
        if (this.isEnableTemporary()) {
            stack.method_22904((double)this.temporaryPosition.method_4943(), (double)this.temporaryPosition.method_4945(), (double)this.temporaryPosition.method_4947());
            this.temporaryRotation.pose(stack);
        }
    }

    public void onDebug(@NotNull class_4587 stack, class_4597 multiBufferSource, float scale) {
        if (!OtyacraftEngine.isTestMode()) {
            return;
        }
        this.poseDebug(stack);
        if (!this.isShowOrigin()) {
            return;
        }
        stack.method_22903();
        stack.method_22903();
        stack.method_22904((double)this.rotation.origin().method_4943(), (double)this.rotation.origin().method_4945(), (double)this.rotation.origin().method_4947());
        OERenderUtil.poseScaleAll(stack, 0.1f * scale);
        OERenderUtil.renderModel(stack, multiBufferSource.getBuffer(class_4722.method_24074()), OEModelUtil.getModel(OETestModels.XYZ_AXIS), 0xF000F0, class_4608.field_21444);
        stack.method_22909();
        stack.method_22903();
        stack.method_22904((double)this.rotation.origin().method_4943(), (double)this.rotation.origin().method_4945(), (double)this.rotation.origin().method_4947());
        OERenderUtil.poseScaleAll(stack, scale);
        OERenderUtil.renderModel(stack, multiBufferSource.getBuffer(class_4722.method_24074()), OEModelUtil.getModel(OETestModels.ORIGIN), 0xF000F0, class_4608.field_21444);
        stack.method_22909();
        stack.method_22909();
    }

    public MotionPoint createPoint() {
        return new MotionPoint(this.getPosition().method_23850(), this.getRotation().copy(), this.ratio);
    }

    public void setPoint(MotionPoint point) {
        this.setPosition(point.getPosition());
        this.setRotation(point.getRotation());
        this.setRatio(point.getRatio());
    }

    @NotNull
    public Motion createMotion() {
        return new Motion((List<MotionPoint>)ImmutableList.copyOf(this.getPoints()));
    }

    public void setMotion(Motion motion) {
        this.reset();
        this.points.clear();
        this.points.addAll(motion.getPoints());
    }

    public void startMotion(long cycleSpeed) {
        this.playMotion = this.createMotion();
        this.cycleSpeed = cycleSpeed;
    }

    public void stopMotion() {
        this.playMotion = null;
    }

    public boolean isMotionPlaying() {
        return this.playMotion != null;
    }

    private static class DebugOption {
        private boolean enableTemporary;
        private boolean editTemporary;
        @NotNull
        private EditType editType = EditType.POSITION;
        private float sensitivity = 1.0f;
        private boolean fixOrigin = true;
        private boolean showOrigin = true;

        private DebugOption() {
        }
    }

    public record SimpleRotation(class_1160 angle, class_1160 origin) {
        public SimpleRotation() {
            this(new class_1160(), new class_1160());
        }

        public void pose(class_4587 poseStack) {
            poseStack.method_22904((double)this.origin.method_4943(), (double)this.origin.method_4945(), (double)this.origin.method_4947());
            OERenderUtil.poseRotateAll(poseStack, this.angle.method_4943(), this.angle.method_4945(), this.angle.method_4947());
            poseStack.method_22904((double)(-this.origin.method_4943()), (double)(-this.origin.method_4945()), (double)(-this.origin.method_4947()));
        }
    }

    public static enum EditType {
        POSITION,
        ROTATION,
        ROTATION_ORIGIN;

    }
}

