package dev.felnull.otyacraftengine.inventory;

import com.mojang.datafixers.util.Pair;
import dev.felnull.otyacraftengine.inventory.slot.LockedSlot;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import org.jetbrains.annotations.Nullable;

import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public abstract class OEItemBaseMenu extends OEBaseMenu {
    private final class_1799 itemStack;
    private final IPlayerItemLocation location;

    protected OEItemBaseMenu(@Nullable class_3917<?> menuType, int i, class_1661 playerInventory, class_1263 container, class_1799 stack, IPlayerItemLocation location, int playerSlotX, int playerSlotY) {
        super(menuType, i, playerInventory, container, -1, -1);
        this.itemStack = stack;
        this.location = location;
        setPlayerSlot(playerSlotX, playerSlotY);
    }

    @Override
    protected void setPlayerSlot(int x, int y) {
        if (x >= 0 && y >= 0) {
            IntStream.range(0, 3).forEach(k -> IntStream.range(0, 9).forEach(i1 -> this.method_7621(new LockedSlot(getPlayerInventory(), itemStack, i1 + k * 9 + 9, x + i1 * 18, y + k * 18))));
            IntStream.range(0, 9).forEach(l -> this.method_7621(new LockedSlot(getPlayerInventory(), itemStack, l, x + l * 18, y + 58)));
            if (isActiveOffHandSlot())
                this.method_7621(new LockedSlot(getPlayerInventory(), itemStack, class_1661.field_30639, x + 166, y + 58) {
                    public Pair<class_2960, class_2960> method_7679() {
                        return Pair.of(class_1723.field_21668, class_1723.field_21673);
                    }
                });
        }
    }

    @Override
    protected boolean isActiveOffHandSlot() {
        return true;
    }

    public class_1799 getItemStack() {
        return itemStack;
    }

    public class_1799 getItemStack(class_1657 player) {
        if (location == null)
            return class_1799.field_8037;
        return location.getItem(player);
    }

    public IPlayerItemLocation getLocation() {
        return location;
    }

    @Override
    public boolean isBlock() {
        return false;
    }
}
