package dev.felnull.otyacraftengine.block;

import dev.felnull.otyacraftengine.blockentity.ItemDroppedBlockEntity;
import dev.felnull.otyacraftengine.blockentity.OEBaseContainerBlockEntity;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_47;

public abstract class OEBaseEntityBlock extends class_2237 implements class_3737 {
    public static final class_2960 CONTENTS = new class_2960("contents");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private boolean analogOutput;

    protected OEBaseEntityBlock(class_2251 properties) {
        super(properties);
        this.method_9590(this.field_10647.method_11664().method_11657(WATERLOGGED, false));
    }

    @Override
    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        if (itemStack.method_7938()) {
            if (level.method_8321(blockPos) instanceof class_2624 container) {
                container.method_17488(itemStack.method_7964());
            }
        }
    }

    @Override
    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState.method_27852(blockState2.method_26204())) {
            var be = level.method_8321(blockPos);
            if (level instanceof class_3218) {
                if (be instanceof ItemDroppedBlockEntity itemDroppedBlock) {
                    if (!itemDroppedBlock.isRetainDrop())
                        class_1264.method_17349(level, blockPos, itemDroppedBlock.getDroppedItems());
                } else if (be instanceof class_1263 container) {
                    class_1264.method_5451(level, blockPos, container);
                }
            }
            if (be instanceof class_1263 && analogOutput)
                level.method_8455(blockPos, this);

        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }


    @Override
    public void method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        var be = level.method_8321(blockPos);
        if (be instanceof ItemDroppedBlockEntity itemDroppedBlock && itemDroppedBlock.isRetainDrop()) {
            if (!level.field_9236 && player.method_7337() && !itemDroppedBlock.isRetainEmpty()) {
                var itemStack = itemDroppedBlock.createRetainDropItem();

                if (be instanceof class_2624 named) {
                    if (named.method_16914())
                        itemStack.setHoverName(named.method_5797());
                }

                class_1542 itemEntity = new class_1542(level, (double) blockPos.method_10263() + 0.5D, (double) blockPos.method_10264() + 0.5D, (double) blockPos.method_10260() + 0.5D, itemStack);
                itemEntity.method_6988();
                level.method_8649(itemEntity);
            }
        }
        super.method_9576(level, blockPos, blockState, player);
    }

    @Override
    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        } else {
            this.openContainer(level, blockPos, (class_3222) player, blockState, blockHitResult.method_17780());
            return class_1269.field_21466;
        }
    }

    protected void openContainer(class_1937 level, class_2338 blockPos, class_3222 player, class_2680 blockState, class_2350 direction) {
        if (level.method_8321(blockPos) instanceof OEBaseContainerBlockEntity oeBaseContainerBlock)
            OEMenuUtil.openBlockMenu(player, oeBaseContainerBlock, blockPos, oeBaseContainerBlock.method_5439());
    }

    @Override
    public boolean method_9498(class_2680 blockState) {
        return analogOutput;
    }

    @Override
    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        if (!analogOutput)
            return super.method_9572(blockState, level, blockPos);
        return class_1703.method_7608(level.method_8321(blockPos));
    }

    public void setAnalogOutput(boolean enable) {
        this.analogOutput = enable;
    }

    @Override
    public boolean method_9579(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return !blockState.method_11654(WATERLOGGED);
    }

    @Override
    public class_3610 method_9545(class_2680 blockState) {
        return blockState.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    @Override
    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        if (blockState.method_11654(WATERLOGGED)) {
            levelAccessor.method_39281(blockPos, class_3612.field_15910, class_3612.field_15910.method_15789(levelAccessor));
        }
        return super.method_9559(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        return super.method_9605(blockPlaceContext).method_11657(WATERLOGGED, fluidState.method_15772() == class_3612.field_15910);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED);
    }

    @Override
    public List<class_1799> method_9560(class_2680 blockState, class_47.class_48 builder) {
        class_2586 blockEntity = builder.method_305(class_181.field_1228);
        if (blockEntity instanceof ItemDroppedBlockEntity icbe && icbe.isRetainDrop())
            return List.of(icbe.createRetainDropItem());
        return super.method_9560(blockState, builder);
    }
}
