package dev.felnull.otyacraftengine.client.util;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.mixin.client.ScreenAccessor;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.List;
import net.minecraft.class_339;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class OEScreenUtil {
    @NotNull
    public static List<class_4068> getRenderableWidgets(@NotNull class_437 screen) {
        ScreenAccessor sa = (ScreenAccessor) screen;
        return sa.getRenderables();
    }

    @NotNull
    public static List<class_339> getRenderableAbstractWidgets(@NotNull class_437 screen) {
        ImmutableList.Builder<class_339> builder = ImmutableList.builder();
        var wds = getRenderableWidgets(screen);
        for (class_4068 wd : wds) {
            if (wd instanceof class_339 abstractWidget)
                builder.add(abstractWidget);
        }
        return builder.build();
    }
}
