package dev.felnull.otyacraftengine.client.debug;

import SimpleRotation;
import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.model.OETestModels;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import record;
import var;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_765;

public class MotionDebug {
    private static final MotionDebug INSTANCE = new MotionDebug();
    private final List<MotionPoint> points = new ArrayList<>();
    private final DebugOption option = new DebugOption();
    private class_1160 position = new class_1160();
    private MotionRotation rotation = new MotionRotation();
    private float ratio = 1f;
    private class_1160 temporaryPosition = new class_1160();
    private SimpleRotation temporaryRotation = new SimpleRotation();
    private Motion playMotion;
    private long cycleSpeed;

    @NotNull
    public static MotionDebug getInstance() {
        return INSTANCE;
    }

    @NotNull
    public EditType getEditType() {
        return option.editType;
    }

    public boolean isFixOrigin() {
        return option.fixOrigin;
    }

    public void setFixOrigin(boolean fix) {
        option.fixOrigin = fix;
    }

    public boolean isShowOrigin() {
        return option.showOrigin;
    }

    public void setShowOrigin(boolean show) {
        this.option.showOrigin = show;
    }

    public boolean isEnableTemporary() {
        return option.enableTemporary;
    }

    public boolean isEditTemporary() {
        return option.editTemporary;
    }

    public float getSensitivity() {
        return option.sensitivity;
    }

    public void setEditType(@NotNull EditType editType) {
        option.editType = editType;
    }

    public void setEnableTemporary(boolean enable) {
        option.enableTemporary = enable;
    }

    public void setEditTemporary(boolean editTemporary) {
        option.editTemporary = editTemporary;
    }

    public void setSensitivity(float sensitivity) {
        option.sensitivity = sensitivity;
    }

    public class_1160 getTemporaryPosition() {
        return temporaryPosition;
    }

    public SimpleRotation getTemporaryRotation() {
        return temporaryRotation;
    }

    public List<MotionPoint> getPoints() {
        return points;
    }

    public class_1160 getPosition() {
        return position;
    }

    public MotionRotation getRotation() {
        return rotation;
    }

    public float getRatio() {
        return ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public void setPosition(class_1160 position) {
        this.position = position;
    }

    public void setRotation(MotionRotation rotation) {
        this.rotation = rotation;
    }

    public void setRotationAngle(class_1160 angle) {
        var o = rotation.copy();
        setRotation(new MotionRotation(angle, o.origin(), o.reset()));
    }

    public void setRotationOrigin(class_1160 origin) {
        setRotationOrigin(origin, false);
    }

    public void setRotationOrigin(class_1160 origin, boolean force) {
        if (isFixOrigin() && !force) return;
        var o = rotation.copy();
        setRotation(new MotionRotation(o.angle(), origin, o.reset()));
    }

    public void setTemporaryPosition(class_1160 temporaryPosition) {
        this.temporaryPosition = temporaryPosition;
    }

    public void setTemporaryRotation(SimpleRotation temporaryRotation) {
        this.temporaryRotation = temporaryRotation;
    }

    public void addPosition(float x, float y, float z) {
        var o = getPosition().method_23850();
        o.add(x, y, z);
        setPosition(o);
    }

    public void addRotationAngle(float x, float y, float z) {
        var o = getRotation().angle().copy();
        o.add(x, y, z);
        setRotation(new MotionRotation(o, getRotation().origin(), getRotation().reset()));
    }

    public void setRotationReset(boolean x, boolean y, boolean z) {
        setRotation(new MotionRotation(getRotation().angle(), getRotation().origin(), Triple.of(x, y, z)));
    }

    public void addRotationOrigin(float x, float y, float z) {
        if (isFixOrigin()) return;
        var o = getRotation().origin().copy();
        o.add(x, y, z);
        setRotation(new MotionRotation(getRotation().angle(), o, getRotation().reset()));
    }

    public void addTemporaryPosition(float x, float y, float z) {
        var o = getTemporaryPosition().method_23850();
        o.add(x, y, z);
        setTemporaryPosition(o);
    }

    public void addTemporaryRotationAngle(float x, float y, float z) {
        var o = getTemporaryRotation().angle().copy();
        o.add(x, y, z);
        setTemporaryRotation(new SimpleRotation(o, getRotation().origin()));
    }

    public void addTemporaryRotationOrigin(float x, float y, float z) {
        if (isFixOrigin()) return;
        var o = getTemporaryRotation().origin().copy();
        o.add(x, y, z);
        setTemporaryRotation(new SimpleRotation(getRotation().angle(), o));
    }

    public void reset() {
        if (isEditTemporary()) {
            setTemporaryPosition(new class_1160());
            setTemporaryRotation(new SimpleRotation());
        } else {
            setPosition(new class_1160());
            var or = getRotation().origin().copy();
            setRotation(new MotionRotation());
            if (isFixOrigin())
                setRotationOrigin(or, true);
        }
    }

    public MotionPose getPose() {
        return new MotionPose(position, rotation);
    }

    public MotionPose getDebugPose() {
        if (playMotion == null)
            return getPose();
        return playMotion.getPose(OERenderUtil.getParSecond(cycleSpeed));
    }

    public void pose(@NotNull class_4587 stack) {
        stack.method_22904(position.method_4943(), position.method_4945(), position.method_4947());
        rotation.pose(stack);
        if (isEnableTemporary()) {
            stack.method_22904(temporaryPosition.method_4943(), temporaryPosition.method_4945(), temporaryPosition.method_4947());
            temporaryRotation.pose(stack);
        }
    }

    public void poseDebug(@NotNull class_4587 stack) {
        if (playMotion == null) {
            pose(stack);
            return;
        }
        playMotion.pose(stack, OERenderUtil.getParSecond(cycleSpeed));
        if (isEnableTemporary()) {
            stack.method_22904(temporaryPosition.method_4943(), temporaryPosition.method_4945(), temporaryPosition.method_4947());
            temporaryRotation.pose(stack);
        }
    }

    public void onDebug(@NotNull class_4587 stack, class_4597 multiBufferSource, float scale) {
        if (!OtyacraftEngine.isTestMode()) return;
        poseDebug(stack);

        if (!isShowOrigin()) return;
        stack.method_22903();

        stack.method_22903();
        stack.method_22904(rotation.origin().x(), rotation.origin().y(), rotation.origin().z());
        OERenderUtil.poseScaleAll(stack, 0.1f * scale);
        OERenderUtil.renderModel(stack, multiBufferSource.getBuffer(class_4722.method_24074()), OEModelUtil.getModel(OETestModels.XYZ_AXIS), class_765.field_32767, class_4608.field_21444);
        stack.method_22909();

        stack.method_22903();
        stack.method_22904(rotation.origin().x(), rotation.origin().y(), rotation.origin().z());
        OERenderUtil.poseScaleAll(stack, scale);
        OERenderUtil.renderModel(stack, multiBufferSource.getBuffer(class_4722.method_24074()), OEModelUtil.getModel(OETestModels.ORIGIN), class_765.field_32767, class_4608.field_21444);
        stack.method_22909();

        stack.method_22909();
    }

    public MotionPoint createPoint() {
        return new MotionPoint(getPosition().method_23850(), getRotation().copy(), ratio);
    }

    public void setPoint(MotionPoint point) {
        setPosition(point.getPosition());
        setRotation(point.getRotation());
        setRatio(point.getRatio());
    }

    @NotNull
    public Motion createMotion() {
        return new Motion(ImmutableList.copyOf(getPoints()));
    }

    public void setMotion(Motion motion) {
        reset();
        points.clear();
        points.addAll(motion.getPoints());
    }

    public void startMotion(long cycleSpeed) {
        playMotion = createMotion();
        this.cycleSpeed = cycleSpeed;
    }

    public void stopMotion() {
        playMotion = null;
    }

    public boolean isMotionPlaying() {
        return playMotion != null;
    }

    public static record SimpleRotation(class_1160 angle, class_1160 origin) {
        public SimpleRotation() {
            this(new Vector3f(), new Vector3f());
        }

        public void pose(PoseStack poseStack) {
            poseStack.translate(origin.x(), origin.y(), origin.z());
            OERenderUtil.poseRotateAll(poseStack, angle.x(), angle.y(), angle.z());
            poseStack.translate(-origin.x(), -origin.y(), -origin.z());
        }
    }

    private static class DebugOption {
        private boolean enableTemporary;
        private boolean editTemporary;
        @NotNull
        private EditType editType = EditType.POSITION;
        private float sensitivity = 1;
        private boolean fixOrigin = true;
        private boolean showOrigin = true;
    }

    public static enum EditType {
        POSITION, ROTATION, ROTATION_ORIGIN;
    }
}
