package dev.felnull.otyacraftengine.client.debug.socket;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import var;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_310;
import net.minecraft.class_3532;


public class SocketDebugService {
    private static final Logger LOGGER = LogManager.getLogger(SocketDebugService.class);
    private static final Gson GSON = new Gson();
    private static final boolean enable = true;
    private static final class_310 mc = class_310.method_1551();
    private static final String hostName = "localhost";
    private static final int port = 1919;
    public static DebugConnection connection;
    private static class_1160 rawAngle = new class_1160();
    private static class_1160 angle = new class_1160();
    private static class_1160 oldAngle = new class_1160();
    private static boolean yAngleFlag;
    private static boolean zAngleFlag;
    private static class_1160 rawPosition = new class_1160();
    private static class_1160 position = new class_1160();
    private static class_1160 oldPosition = new class_1160();

    public static void start() {
        if (!enable) return;

        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (connection != null) {
                try {
                    connection.close();
                } catch (Exception ignored) {
                }
            }
        }));

        var ct = new ConnectionThread();
        ct.start();
    }

    public static void tick() {
        if (!enable) return;
        oldAngle = angle;
        angle = rawAngle;

        oldPosition = position;
        position = rawPosition;
    }

    public static void onText(String text) {
        try {
            var uuid = UUID.fromString(text);
            connection.sendText(uuid.toString());
            return;
        } catch (Exception ignored) {
        }
        try {
            var jo = GSON.fromJson(text, JsonObject.class);
            parse(jo);
        } catch (Exception ignored) {
        }
    }

    private static void parse(JsonObject jo) {
        if (!jo.has("type")) return;
        var type = jo.get("type").getAsString();
        if ("update".equals(type)) {
            yAngleFlag = jo.get("ayflg").getAsBoolean();
            zAngleFlag = jo.get("azflg").getAsBoolean();
            rawAngle = createAngle(jo.get("ax").getAsFloat(), fixP(jo.get("ay").getAsFloat(), yAngleFlag, zAngleFlag), jo.get("az").getAsFloat());
            boolean yFixAngleFlag = jo.get("ayflgf").getAsBoolean();
            boolean zFixAngleFlag = jo.get("azflgf").getAsBoolean();
            var fAngle = createAngle(jo.get("axf").getAsFloat(), fixP(jo.get("ayf").getAsFloat(), yFixAngleFlag, zFixAngleFlag), jo.get("azf").getAsFloat());
            rawAngle.method_4944(fAngle);
            rawAngle = new class_1160(fixRoted(rawAngle.method_4943()), fixRoted(rawAngle.method_4945()), fixRoted(rawAngle.method_4947()));

            rawPosition = new class_1160(jo.get("px").getAsFloat(), jo.get("py").getAsFloat(), jo.get("pz").getAsFloat());
        }
    }

    private static float fixP(float va, boolean revY, boolean revZ) {
        va = 90 - va;
        if (revY)
            va = 180 - va + 180;
        return va;
    }

    private static class_1160 createAngle(float rx, float ry, float rz) {
        return new class_1160(360f - fixRoted(rx), (fixRoted(ry) - 180) % 360, fixRoted(rz));
    }

    private static float fixRoted(float val) {
        if (val < 0)
            return 360 + val;
        return val;
    }

    private static float lerpRoted(float delta, float old, float current) {
        float mr = 180f;
        float sa = class_3532.method_15379(current - old);
        if (sa > mr) {
            if (old < current)
                current = -(360 - current);
            else
                current = 360 + current;
        }
        return class_3532.method_16439(delta, old, current);
    }

    private static class ConnectionThread extends Thread {
        private ConnectionThread() {
            setName("Debug connection");
            setDaemon(true);
        }

        @Override
        public void run() {
            try {
                connect(hostName, port);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static class_1160 getAngele(float delta) {
        return new class_1160(lerpRoted(delta, oldAngle.method_4943(), angle.method_4943()), lerpRoted(delta, oldAngle.method_4945(), angle.method_4945()), lerpRoted(delta, oldAngle.method_4947(), angle.method_4947()));
    }

    public static class_1160 getPosition(float delta) {
        return new class_1160(class_3532.method_16439(delta, oldPosition.method_4943(), position.method_4943()), class_3532.method_16439(delta, oldPosition.method_4945(), position.method_4945()), class_3532.method_16439(delta, oldPosition.method_4947(), position.method_4947()));
    }

    public static boolean isConnected() {
        if (connection != null)
            return connection.isOpen();
        return false;
    }

    private static void connect(String hostName, int port) throws InterruptedException {
        while (mc.method_22108()) {
            connection = new DebugConnection(hostName, port);
            try {
                connection.run();
            } catch (Exception e) {
                LOGGER.error("Socket connection error", e);
                Thread.sleep(1000);
            } finally {
                connection = null;
            }
        }
    }
}
