package dev.felnull.otyacraftengine.client.gui.components.base;

import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OEBaseWidget extends class_339 implements IOEBaseComponent {
    @Nullable
    private final String widgetTypeName;

    public OEBaseWidget(int x, int y, int width, int height, class_2561 component) {
        this(x, y, width, height, null, component);
    }

    public OEBaseWidget(int x, int y, int width, int height, @Nullable String widgetTypeName, @NotNull class_2561 message) {
        super(x, y, width, height, message);
        this.widgetTypeName = widgetTypeName;
    }

    @Override
    public void method_37020(@NotNull class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    protected void method_37021(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
        if (this.widgetTypeName != null && this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, new class_2588("narration." + widgetTypeName + ".usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, new class_2588("narration." + widgetTypeName + ".usage.hovered"));
            }
        }
    }

    @Override
    protected class_5250 method_25360() {
        if (widgetTypeName == null)
            return new class_2588("gui.narrate.widget", method_25369());
        return new class_2588("gui.narrate." + widgetTypeName, method_25369());
    }

    @Override
    public void method_25348(double d, double e) {
        this.onPress();
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.field_22763 && this.field_22764) {
            if (i != 257 && i != 32 && i != 335) return false;
            this.method_25354(class_310.method_1551().method_1483());
            this.onPress();
            return true;
        }
        return false;
    }

    public abstract void onPress();

    public @Nullable String getWidgetTypeName() {
        return widgetTypeName;
    }
}
