package dev.felnull.otyacraftengine.data;

import dev.architectury.platform.Mod;
import dev.felnull.otyacraftengine.data.provider.BlockTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2474;
import org.jetbrains.annotations.NotNull;

public interface CrossDataGeneratorAccess {
    @NotNull class_2403 getVanillaGenerator();

    void addProvider(@NotNull class_2405 dataProvider);

    default void addProvider(@NotNull DataProviderWrapper<?> dataProviderWrapper) {
        addProvider(dataProviderWrapper.getProvider());
    }

    Mod getMod();

    class_2446 createRecipeProvider(RecipeProviderWrapper recipeProviderWrapper);

    class_2474<class_1792> createItemTagProvider(ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper);

    class_2474<class_2248> createBlockTagProvider(BlockTagProviderWrapper blockTagProviderWrapper);
}
