package dev.felnull.otyacraftengine.client.event;

import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_572;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public interface ClientEvent {
    Event<ChangeHandHeight> CHANGE_HAND_HEIGHT = EventFactory.createEventResult();
    Event<PoseHumanoidArm> POSE_HUMANOID_ARM = EventFactory.createEventResult();
    Event<PoseHumanoidArmPost> POSE_HUMANOID_ARM_POST = EventFactory.createLoop();
    Event<PauseChange> INTEGRATED_SERVER_PAUSE = EventFactory.createLoop();
    Event<HandAttack> HAND_ATTACK = EventFactory.createEventResult();
    Event<EvaluateRenderHands> EVALUATE_RENDER_HANDS = EventFactory.createLoop();

    interface ChangeHandHeight {
        EventResult changeHandHeight(class_1268 hand, class_1799 oldStack, class_1799 newStack);
    }

    interface PoseHumanoidArm {
        EventResult poseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity);
    }

    interface PoseHumanoidArmPost {
        void poseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity);
    }

    interface PauseChange {
        void onPauseChange(boolean paused);
    }

    interface HandAttack {
        EventResult onHandAttack(@NotNull class_1799 itemStack);
    }

    interface EvaluateRenderHands {
        void onEvaluateRenderHands(HandRenderSelectionWrapper handRenderSelection, class_746 player, EvaluateRenderHandSetter setter);
    }

    interface EvaluateRenderHandSetter {
        void setEvaluate(HandRenderSelectionWrapper wrapper);
    }

    enum HandRenderSelectionWrapper {
        RENDER_BOTH_HANDS,
        RENDER_MAIN_HAND_ONLY,
        RENDER_OFF_HAND_ONLY;

        public static HandRenderSelectionWrapper onlyForHand(class_1268 interactionHand) {
            return interactionHand == class_1268.field_5808 ? RENDER_MAIN_HAND_ONLY : RENDER_OFF_HAND_ONLY;
        }
    }
}
