package dev.felnull.otyacraftengine.client.model;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_2960;

@ApiStatus.Internal
public class ModelHolderImpl implements ModelHolder {
    private final class_2960 modelLocation;
    private Supplier<class_1087> modelSupplier;

    protected ModelHolderImpl(class_2960 modelLocation) {
        this.modelLocation = modelLocation;
    }

    @Override
    public @NotNull class_1087 get() {
        if (modelSupplier == null)
            throw new RuntimeException("Unregistered model");

        return modelSupplier.get();
    }

    @Override
    public @NotNull class_2960 getLocation() {
        return modelLocation;
    }

    @Override
    public void setModelSupplier(Supplier<class_1087> modelSupplier) {
        this.modelSupplier = modelSupplier;
    }
}
