package dev.felnull.otyacraftengine.shape.bundle;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_265;

public abstract class AbstractVoxelShapeBundle<T> implements VoxelShapeBundle<T> {
    private final Map<T, class_265> shapeCache = new HashMap<>();

    protected AbstractVoxelShapeBundle() {
    }

    protected void preGen() {
        forAssumption(v -> shapeCache.put(v, generate(v)));
    }

    abstract void forAssumption(Consumer<T> consumer);

    abstract class_265 generate(T value);

    @Override
    public class_265 getShape(T value) {
        return shapeCache.get(value);
    }
}
