package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.util.OEEntityUtils;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.world.item.*;

import java.util.*;


public class ClientDebugHandler {
    public static void init() {
        ClientTooltipEvent.ITEM.register(ClientDebugHandler::onTooltip);
    }

    private static void onTooltip(class_1799 stack, List<class_2561> lines, class_1836 flag) {
        if (stack.method_7960()) return;
        var oed = OtyacraftEngineClientDebug.getInstance();
        if (oed.isShowTagInTooltip()) {
            var itemTags = new ArrayList<>(stack.method_40133().map(class_6862::comp_327).toList());

            if (stack.method_7909() instanceof class_1747 blockItem) {
                var blockTags = new ArrayList<>(blockItem.method_7711().method_9564().method_40144().map(class_6862::comp_327).toList());
                Set<class_2960> bothTags = new TreeSet<>();
                for (class_2960 tag : itemTags) {
                    if (blockTags.contains(tag))
                        bothTags.add(tag);
                }
                itemTags.removeAll(bothTags);
                blockTags.removeAll(bothTags);
                addTagList(lines, "Item tags", itemTags);
                addTagList(lines, "Block tags", blockTags);
                addTagList(lines, "Both tags", bothTags);
            } else {
                addTagList(lines, "Item tags", itemTags);
            }

            var entityTypes = getEntityTypesByItem(stack);
            var entityTypeTags = entityTypes.stream().flatMap(OEEntityUtils::getTags).map(class_6862::comp_327).toList();
            addTagList(lines, "Entity tags", entityTypeTags);
        }

        if (oed.isShowModNameInTooltip()) {
            var modid = OEItemUtils.getCreatorModId(stack);
            lines.add(class_2561.method_43470(Platform.getMod(modid).getName()).method_27692(class_124.field_1077));
        }
    }

    private static void addTagList(List<class_2561> lines, String text, Collection<class_2960> tags) {
        if (tags.isEmpty()) return;
        lines.add(class_2561.method_43470(text).method_27692(class_124.field_1080));
        for (class_2960 tag : tags) {
            lines.add(class_2561.method_43470("- " + tag));
        }
    }

    private static Set<class_1299<?>> getEntityTypesByItem(class_1799 stack) {
        var item = stack.method_7909();
        if (item instanceof class_1826 spawnEggItem) {
            return Set.of(spawnEggItem.method_8015(stack.method_7969()));
        } else if (item instanceof class_1785 mobBucketItem) {
            return Set.of(OEItemUtils.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}
