/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.fnjl.util.FNMath;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.renderer.texture.DynamicGifTexture;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureScale;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OETextureUtils {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 ERROR_ICON = new class_2960("otyacraftengine", "textures/gui/error_icon.png");
    private static class_2960 LOADING_ICON;

    @NotNull
    public static class_1043 createNativeTexture(@NotNull InputStream stream, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        if (progress != null) {
            progress.accept(new TextureLoadProgressImpl("Image loading", 1, 0));
        }
        byte[] data = stream.readAllBytes();
        if (progress != null) {
            progress.accept(new TextureLoadProgressImpl("Image loading", 1, 1));
        }
        try (ByteArrayInputStream istream = new ByteArrayInputStream(data);){
            GifDecoder decoder = new GifDecoder();
            if (decoder.read((InputStream)istream) == 0) {
                DynamicGifTexture dynamicGifTexture = DynamicGifTexture.create(decoder, progress);
                return dynamicGifTexture;
            }
        }
        istream = new ByteArrayInputStream(data);
        try {
            class_1043 class_10432 = new class_1043(class_1011.method_4309((InputStream)istream));
            return class_10432;
        }
        finally {
            istream.close();
        }
    }

    public static synchronized void freeTexture(@NotNull class_2960 location) {
        class_1060 textureManager = mc.method_1531();
        class_1044 abstractTexture = (class_1044)textureManager.field_5286.get(location);
        if (abstractTexture != null) {
            if (abstractTexture instanceof class_1061) {
                textureManager.field_5284.remove(abstractTexture);
            }
            textureManager.method_30299(location, abstractTexture);
        }
    }

    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTextureAsync(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTextureAsync(uuid, stream);
    }

    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTexture(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTexture(uuid, stream);
    }

    @Nullable
    public static NativeTextureLoadResult getNativeTexture(@NotNull UUID uuid) {
        return NativeTextureManager.getInstance().getTexture(uuid);
    }

    @NotNull
    public static TextureLoadResult getAndLoadURLTextureAsync(@NotNull String url, boolean cached) {
        return URLTextureManager.getInstance().getAndAsyncLoad(url, cached);
    }

    @NotNull
    public static class_2960 getLoadingIcon() {
        if (LOADING_ICON == null) {
            class_3300 rm = mc.method_1478();
            Optional r = rm.method_14486(new class_2960("otyacraftengine", "textures/gui/loading_icon.gif"));
            if (r.isPresent()) {
                try (InputStream st = ((class_3298)r.get()).method_14482();){
                    NativeTextureLoadResult ret = OETextureUtils.getAndLoadNativeTexture(UUID.randomUUID(), st);
                    if (ret.isSuccess()) {
                        LOADING_ICON = ret.getLocation();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (LOADING_ICON == null) {
                throw new IllegalStateException("Failed to loading icon being loaded.");
            }
        }
        return LOADING_ICON;
    }

    @NotNull
    public static class_2960 getErrorIcon() {
        return ERROR_ICON;
    }

    @Nullable
    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, uuid);
    }

    @Nullable
    public static class_2960 getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, name);
    }

    @Nullable
    public static class_2960 getPlayerElytraTexture(@NotNull String name) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    @Nullable
    public static class_2960 getPlayerCapeTexture(@NotNull String name) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    @NotNull
    public static class_2960 getPlayerSkinTexture(@NotNull String name) {
        return Objects.requireNonNull(OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name));
    }

    @Nullable
    public static class_2960 getPlayerElytraTexture(@NotNull UUID uuid) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, uuid);
    }

    @Nullable
    public static class_2960 getPlayerCapeTexture(@NotNull UUID uuid) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, uuid);
    }

    @NotNull
    public static class_2960 getPlayerSkinTexture(@NotNull UUID uuid) {
        return Objects.requireNonNull(OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, uuid));
    }

    public static TextureScale getTextureScale(class_2960 location) {
        class_1044 class_10442;
        if (location != null && (class_10442 = mc.method_1531().method_4619(location)) instanceof class_1043) {
            class_1043 texture = (class_1043)class_10442;
            int w = texture.method_4525().method_4307();
            int h = texture.method_4525().method_4323();
            FNVec2d sc = FNMath.scale((double)w, (double)h);
            return new TextureScale(sc.getX(), sc.getY());
        }
        return null;
    }
}

