package dev.felnull.otyacraftengine.client.gui.components;

import dev.felnull.otyacraftengine.client.gui.TextureSpecify;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class RadioButton extends OEBaseImageWidget {
    @Nullable
    private final Consumer<RadioButton> onPress;
    @NotNull
    private final Supplier<Set<RadioButton>> group;
    private boolean showLabel;
    private boolean selected;

    public RadioButton(int x, int y, @NotNull class_2561 message, @Nullable Consumer<RadioButton> onPress, @NotNull Supplier<Set<RadioButton>> group, boolean showLabel) {
        this(x, y, 20, 20, message, onPress, group, showLabel, TextureSpecify.createRelative(WIDGETS, 0, 0, 20, 20));
    }

    public RadioButton(int x, int y, int width, int height, @NotNull class_2561 message, @Nullable Consumer<RadioButton> onPress, @NotNull Supplier<Set<RadioButton>> group, boolean showLabel, @NotNull TextureSpecify texture) {
        super(x, y, width, height, "radioButton", message, texture);
        this.onPress = onPress;
        this.group = group;
        this.showLabel = showLabel;
    }

    @Override
    public void method_25359(@NotNull class_4587 poseStack, int i, int j, float f) {
        OERenderUtils.drawTexture(texture.getTextureLocation(), poseStack, field_22760, field_22761, texture.getU0() + (this.method_25367() ? 20 : 0), texture.getV0() + (this.selected ? 20 : 0), texture.getU1(), texture.getV1(), texture.getTextureWidth(), texture.getTextureHeight());
        this.method_25353(poseStack, mc, i, j);
        if (this.showLabel)
            drawTextBase(poseStack, this.method_25369(), this.field_22760 + 24, this.field_22761 + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    @Override
    public void onPress() {
        this.selected = true;
        for (RadioButton rdo : group.get()) {
            if (this != rdo)
                rdo.selected = false;
        }
        if (onPress != null)
            this.onPress.accept(this);
    }

    public boolean isShowLabel() {
        return showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}