package dev.felnull.otyacraftengine.server.util;

import dev.felnull.otyacraftengine.server.level.saveddata.OEBaseSavedData;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.function.Supplier;

public class OESaveDataUtils {
    @NotNull
    public static <T extends OEBaseSavedData> T getSaveData(@NotNull class_3218 level, @NotNull String name, @NotNull Supplier<T> createSupplier) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(createSupplier);

        return level.method_17983().method_17924(tag -> {
            var d = createSupplier.get();
            d.load(tag);
            return d;
        }, createSupplier, name);
    }

    @NotNull
    public static <T extends OEBaseSavedData> T getSaveData(@NotNull MinecraftServer server, @NotNull String name, @NotNull Supplier<T> createSupplier) {
        return getSaveData(Objects.requireNonNull(server.method_3847(class_1937.field_25179)), name, createSupplier);
    }
}
