package dev.felnull.otyacraftengine.advancement;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModRootTrigger extends class_4558<ModRootTrigger.TriggerInstance> {
    static final class_2960 ID = new class_2960(OtyacraftEngine.MODID, "mod_root");

    @Override
    public class_2960 method_794() {
        return ID;
    }

    @Override
    protected TriggerInstance method_27854(JsonObject jsonObject, class_2048.@NotNull class_5258 composite, @NotNull class_5257 deserializationContext) {
        String mid = jsonObject.has("modid") ? jsonObject.get("modid").getAsString() : null;
        return new TriggerInstance(composite, mid);
    }

    public void trigger(class_3222 serverPlayer, class_1799 itemStack) {
        this.method_22510(serverPlayer, (triggerInstance) -> triggerInstance.matches(itemStack));
    }

    public static class TriggerInstance extends class_195 {
        @Nullable
        private final String modId;

        public TriggerInstance(class_2048.class_5258 composite, @Nullable String modId) {
            super(ID, composite);
            this.modId = modId;
        }

        private boolean matches(class_1799 stack) {
            var id = OEItemUtils.getCreatorModId(stack);
            if (id == null) return false;
            return id.equals(modId);
        }

        @Override
        public JsonObject method_807(@NotNull class_5267 serializationContext) {
            var jo = super.method_807(serializationContext);
            if (modId != null)
                jo.addProperty("modid", modId);
            return jo;
        }
    }
}
