package dev.felnull.otyacraftengine.util;

import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.otyacraftengine.blockentity.BlockEntityCreateSupplier;
import dev.felnull.otyacraftengine.explatform.OERegisterExpectPlatform;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3853;

/**
 * 登録関係のユーティリティ
 *
 * @author MORIMORI0317
 */
public class OERegisterUtils {
    @NotNull
    public static <T extends class_2586> class_2591<T> createBlockEntity(@NotNull BlockEntityCreateSupplier<? extends T> supplier, RegistrySupplier<class_2248>... blocks) {
        return createBlockEntity(supplier, Arrays.stream(blocks).map(Supplier::get).toList().toArray(new class_2248[0]));
    }

    @NotNull
    public static <T extends class_2586> class_2591<T> createBlockEntity(@NotNull BlockEntityCreateSupplier<? extends T> supplier, class_2248... blocks) {
        return OERegisterExpectPlatform.createBlockEntity(supplier, blocks);
    }

    public static class_3853.class_1652 createTradeEmeraldForItems(class_1935 item, int cost, int maxUses, int villagerXp) {
        return new class_3853.class_4161(item, cost, maxUses, villagerXp);
    }

    public static class_3853.class_1652 createTradeItemsForEmeralds(class_1799 itemStack, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
        return new class_3853.class_4165(itemStack, emeraldCost, numberOfItems, maxUses, villagerXp);
    }

    public static Set<class_2680> getPoiTypeBlockStates(class_2248 block) {
        return OERegisterExpectPlatform.getPoiTypeBlockStates(block);
    }
}
