/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture.impl;

import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import java.util.UUID;
import net.minecraft.class_2960;

public class URLTextureLoadResult
implements TextureLoadResult {
    private final Exception exception;
    private final boolean needReload;
    private final long loadedTime;
    private final NativeTextureLoadResult loadResult;
    private final UUID uuid;
    private TextureLoadProgress progress = new TextureLoadProgressImpl();

    public URLTextureLoadResult(Exception exception, boolean needReload, long loadedTime, NativeTextureLoadResult loadResult, UUID uuid) {
        this.exception = exception;
        this.needReload = needReload;
        this.loadedTime = loadedTime;
        this.loadResult = loadResult;
        this.uuid = uuid;
    }

    public URLTextureLoadResult(Exception exception, boolean needReload, NativeTextureLoadResult loadResult, UUID uuid) {
        this(exception, needReload, System.currentTimeMillis(), loadResult, uuid);
    }

    @Override
    public class_2960 getLocation() {
        if (this.loadResult == null) {
            return null;
        }
        return this.loadResult.getLocation();
    }

    @Override
    public boolean isLoading() {
        return this.getLocation() == null && this.exception == null && this.loadedTime == -1L;
    }

    @Override
    public boolean isError() {
        return this.exception != null;
    }

    @Override
    public boolean isSuccess() {
        return !this.isLoading() && !this.isError();
    }

    @Override
    public Exception getException() {
        if (this.exception != null) {
            return this.exception;
        }
        if (this.loadResult != null) {
            return this.loadResult.getException();
        }
        return null;
    }

    @Override
    public TextureLoadProgress getProgress() {
        return this.progress;
    }

    public long getLoadedTime() {
        return this.loadedTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isNeedReload() {
        return this.needReload;
    }

    public NativeTextureLoadResult getNativeResult() {
        return this.loadResult;
    }

    public void setProgress(TextureLoadProgress progress) {
        this.progress = progress;
    }
}

