package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.entity.PlayerInfoManager;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_4538;

/**
 * プレイヤー関係のユーティリティ
 *
 * @author MORIMORI0317
 */
public class OEPlayerUtils {
    /**
     * チャンクのプレイヤーに対しての処理
     *
     * @param chunk          チャンク
     * @param playerConsumer プレイヤーの処理
     */
    public static void doPlayers(@NotNull class_2818 chunk, @NotNull Consumer<class_3222> playerConsumer) {
        ((class_3215) chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(playerConsumer);
    }

    /**
     * BlockPosからチャンクを取得しそのチャンクのプレイヤーに対しての処理
     *
     * @param level          LevelReader
     * @param pos            BlockPos
     * @param playerConsumer プレイヤーの処理
     */
    public static void doPlayers(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull Consumer<class_3222> playerConsumer) {
        class_2818 lch = (class_2818) level.method_22350(pos);
        doPlayers(lch, playerConsumer);
    }

    /**
     * プレイヤーにアイテムを渡す
     * インベントリが埋まっている場合はドロップさせる
     *
     * @param player プレイヤー
     * @param stack  アイテムスタック
     */
    public static void giveItem(@NotNull class_3222 player, @NotNull class_1799 stack) {
        if (!player.method_7270(stack))
            player.method_7329(stack, false, true);
    }

    /**
     * プレイヤー名からUUIDを取得
     * 取得失敗や、無効な名前の場合はempty
     *
     * @param name プレイヤー名
     * @return UUID
     */
    @NotNull
    public static Optional<UUID> getUUIDByName(@NotNull String name) {
        return PlayerInfoManager.getInstance().getCachedUUIDByName(name);
    }

    /**
     * UUIDからプレイヤー名を取得
     * 取得失敗や、無効な名前の場合はempty
     *
     * @param uuid UUID
     * @return プレイヤー名
     */
    @NotNull
    public static Optional<String> getNameByUUID(@NotNull UUID uuid) {
        return PlayerInfoManager.getInstance().getCachedNameByUUID(uuid);
    }

    /**
     * 非同期でプレイヤー名からUUIDを取得
     * 取得失敗や、無効な名前の場合はempty
     *
     * @param name プレイヤー名
     * @return UUIDCompletableFuture
     */
    @NotNull
    public static CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        return PlayerInfoManager.getInstance().getCachedUUIDByNameAsync(name);
    }

    /**
     * 非同期でUUIDからプレイヤー名を取得
     * 取得失敗や、無効な名前の場合はempty
     *
     * @param uuid UUID
     * @return プレイヤー名CompletableFuture
     */
    @NotNull
    public static CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        return PlayerInfoManager.getInstance().getCachedNameByUUIDAsync(uuid);
    }
}
