package dev.felnull.otyacraftengine.data;

import dev.architectury.platform.Mod;
import dev.felnull.otyacraftengine.data.provider.*;
import org.jetbrains.annotations.NotNull;

import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2474;
import net.minecraft.class_4158;

public interface CrossDataGeneratorAccess {
    @NotNull class_2403 getVanillaGenerator();

    void addProvider(@NotNull DataGeneratorType dataGeneratorType, @NotNull class_2405 dataProvider);

    default void addProvider(@NotNull DataProviderWrapper<?> dataProviderWrapper) {
        addProvider(dataProviderWrapper.getGeneratorType(), dataProviderWrapper.getProvider());
    }

    Mod getMod();

    class_2446 createRecipeProvider(RecipeProviderWrapper recipeProviderWrapper);

    class_2474<class_1792> createItemTagProvider(ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper);

    class_2474<class_2248> createBlockTagProvider(BlockTagProviderWrapper blockTagProviderWrapper);

    class_2474<class_4158> createPoiTypeTagProvider(PoiTypeTagProviderWrapper poiTypeTagProviderWrapper);

    class_2405 createDevToolProvider(DevToolProviderWrapper devToolProviderWrapper);

    class_2405 createBlockLootTableProvider(BlockLootTableProviderWrapper blockLootTableProviderWrapper);

    class_2405 createAdvancementProvider(AdvancementProviderWrapper advancementProviderWrapper);

    boolean isInclude(DataGeneratorType type);

    Collection<Path> getResourceInputFolders();

    void addResourceInputFolders(Path path);
}
