package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.event.MoreClientLifecycleEvents;
import dev.felnull.otyacraftengine.client.event.OBJLoaderEvent;
import dev.felnull.otyacraftengine.client.renderer.shader.OEShaders;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.entity.PlayerInfoManager;
import java.io.IOException;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_638;

public class ClientHandler {
    public static void init() {
        ClientLifecycleEvent.CLIENT_STOPPING.register(ClientHandler::onStopping);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientHandler::onLevelLoad);
        MoreClientLifecycleEvents.CLIENT_LEVEL_UNLOAD.register(ClientHandler::onLevelUnload);
        ClientTickEvent.CLIENT_POST.register(ClientHandler::ontClientTick);
        ClientReloadShadersEvent.EVENT.register(ClientHandler::onShaderReload);
        OBJLoaderEvent.LOAD_CHECK.register(ClientHandler::onObjLoadCheck);
    }

    private static EventResult onObjLoadCheck(class_2960 location) {
        if (OtyacraftEngine.MODID.equals(location.method_12836()))
            return EventResult.interruptTrue();
        return EventResult.pass();
    }

    private static void onShaderReload(class_3300 manager, ClientReloadShadersEvent.ShadersSink sink) {
        try {
            OEShaders.reload(manager, sink);
        } catch (IOException e) {
            throw new RuntimeException("could not reload test shaders", e);
        }
    }

    private static void onStopping(class_310 minecraft) {
        URLTextureManager.getInstance().saveIndex();
    }

    private static void onLevelLoad(class_638 world) {
        URLTextureManager.getInstance().clear();
        PlayerInfoManager.getInstance().clear();
        ClientPlayerInfoManager.getInstance().clear();
    }

    private static void onLevelUnload(class_638 world) {
        URLTextureManager.getInstance().clear();
        PlayerInfoManager.getInstance().clear();
        ClientPlayerInfoManager.getInstance().clear();
    }

    private static void ontClientTick(class_310 instance) {
        URLTextureManager.getInstance().tick();
    }
}
