package dev.felnull.otyacraftengine.tag;

import dev.felnull.otyacraftengine.data.provider.TagProviderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_6862;

public interface ManualTagHolder<T> {
    static <T> ManualTagHolder<T> of(@NotNull class_6862<T> tagKey, @Nullable Consumer<TagProviderWrapper.TagAppenderWrapper<T>> tagRegister) {
        return new ManualTagHolderImpl<>(tagKey, tagRegister);
    }

    static <T> ManualTagHolder<T> of(@NotNull class_6862<T> tagKey) {
        return new ManualTagHolderImpl<>(tagKey);
    }

    @NotNull
    class_6862<T> getKey();

    void registering(@NotNull TagProviderWrapper.TagProviderAccess<T> tagProviderAccess);
}
