/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.GreedyInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SavedHeadSeekableInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class MediaContainerDetection {
    public static final String UNKNOWN_TITLE = "Unknown title";
    public static final String UNKNOWN_ARTIST = "Unknown artist";
    public static final int STREAM_SCAN_DISTANCE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MediaContainerDetection.class);
    private static final int HEAD_MARK_LIMIT = 1024;
    private final MediaContainerRegistry containerRegistry;
    private final AudioReference reference;
    private final SeekableInputStream inputStream;
    private final MediaContainerHints hints;

    public MediaContainerDetection(MediaContainerRegistry containerRegistry, AudioReference reference, SeekableInputStream inputStream, MediaContainerHints hints) {
        this.containerRegistry = containerRegistry;
        this.reference = reference;
        this.inputStream = inputStream;
        this.hints = hints;
    }

    public MediaContainerDetectionResult detectContainer() {
        MediaContainerDetectionResult result;
        try {
            SavedHeadSeekableInputStream savedHeadInputStream = new SavedHeadSeekableInputStream(this.inputStream, 1024);
            savedHeadInputStream.loadHead();
            result = this.detectContainer(savedHeadInputStream, true);
            if (result == null) {
                result = this.detectContainer(savedHeadInputStream, false);
            }
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Could not read the file for detecting file type.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        return result != null ? result : MediaContainerDetectionResult.unknownFormat();
    }

    private MediaContainerDetectionResult detectContainer(SeekableInputStream innerStream, boolean matchHints) throws IOException {
        for (MediaContainerProbe probe : this.containerRegistry.getAll()) {
            if (matchHints != probe.matchesHints(this.hints)) continue;
            innerStream.seek(0L);
            MediaContainerDetectionResult result = MediaContainerDetection.checkContainer(probe, this.reference, innerStream);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static MediaContainerDetectionResult checkContainer(MediaContainerProbe probe, AudioReference reference, SeekableInputStream inputStream) {
        try {
            return probe.probe(reference, inputStream);
        }
        catch (Exception e) {
            log.warn("Attempting to detect file with container {} failed.", (Object)probe.getName(), (Object)e);
            return null;
        }
    }

    public static boolean checkNextBytes(SeekableInputStream stream, int[] match) throws IOException {
        return MediaContainerDetection.checkNextBytes(stream, match, true);
    }

    public static boolean checkNextBytes(SeekableInputStream stream, int[] match, boolean rewind) throws IOException {
        long position = stream.getPosition();
        boolean result = true;
        for (int matchByte : match) {
            int inputByte = stream.read();
            if (inputByte != -1 && (matchByte == -1 || matchByte == inputByte)) continue;
            result = false;
            break;
        }
        if (rewind) {
            stream.seek(position);
        }
        return result;
    }

    public static boolean matchNextBytesAsRegex(SeekableInputStream stream, int distance, Pattern pattern, Charset charset) throws IOException {
        long position = stream.getPosition();
        byte[] bytes = new byte[distance];
        int read = new GreedyInputStream(stream).read(bytes);
        stream.seek(position);
        if (read == -1) {
            return false;
        }
        String text = new String(bytes, 0, read, charset);
        return pattern.matcher(text).find();
    }
}

