/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3FrameReader;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3TrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import java.io.IOException;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class Mp3ContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(Mp3ContainerProbe.class);
    private static final int[] ID3_TAG = new int[]{73, 68, 51};

    @Override
    public String getName() {
        return "mp3";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        boolean invalidMimeType = hints.mimeType != null && !"audio/mpeg".equalsIgnoreCase(hints.mimeType);
        boolean invalidFileExtension = hints.fileExtension != null && !"mp3".equalsIgnoreCase(hints.fileExtension);
        return hints.present() && !invalidMimeType && !invalidFileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, ID3_TAG)) {
            byte[] frameHeader = new byte[4];
            Mp3FrameReader frameReader = new Mp3FrameReader(inputStream, frameHeader);
            if (!frameReader.scanForFrame(1000, false)) {
                return null;
            }
            inputStream.seek(0L);
        }
        log.debug("Track {} is an MP3 file.", (Object)reference.identifier);
        try (Mp3TrackProvider file = new Mp3TrackProvider(null, inputStream);){
            file.parseHeaders();
            MediaContainerDetectionResult mediaContainerDetectionResult = MediaContainerDetectionResult.supportedFormat(this, null, AudioTrackInfoBuilder.create(reference, inputStream).apply(file).setIsStream(!file.isSeekable()).build());
            return mediaContainerDetectionResult;
        }
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new Mp3AudioTrack(trackInfo, inputStream);
    }
}

