/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3Seeker;
import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3Decoder;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class Mp3XingSeeker
implements Mp3Seeker {
    private static final Logger log = LoggerFactory.getLogger(Mp3XingSeeker.class);
    private static final int XING_OFFSET = 36;
    private static final int ALL_FLAGS = 7;
    private static final ByteBuffer xingTagBuffer = ByteBuffer.wrap(new byte[]{88, 105, 110, 103});
    private final long firstFramePosition;
    private final long contentLength;
    private final long frameCount;
    private final long dataSize;
    private final byte[] seekMapping;
    private final long duration;

    private Mp3XingSeeker(int sampleRate, long firstFramePosition, long contentLength, long frameCount, long dataSize, byte[] seekMapping) {
        this.firstFramePosition = firstFramePosition;
        this.contentLength = contentLength;
        this.frameCount = frameCount;
        this.dataSize = dataSize;
        this.seekMapping = seekMapping;
        this.duration = frameCount * 1152L * 1000L / (long)sampleRate;
    }

    public static Mp3XingSeeker createFromFrame(long firstFramePosition, long contentLength, byte[] frameBuffer) {
        ByteBuffer frame = ByteBuffer.wrap(frameBuffer);
        if (frame.getInt(36) != xingTagBuffer.getInt(0)) {
            return null;
        }
        if ((frame.getInt(40) & 7) != 7) {
            log.debug("Xing tag is present, but is missing some required fields.");
            return null;
        }
        int sampleRate = Mp3Decoder.getFrameSampleRate(frameBuffer, 0);
        long frameCount = frame.getInt(44);
        long dataSize = frame.getInt(48);
        byte[] seekMapping = new byte[100];
        frame.position(52);
        frame.get(seekMapping);
        return new Mp3XingSeeker(sampleRate, firstFramePosition, contentLength, frameCount, dataSize, seekMapping);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seekAndGetFrameIndex(long timecode, SeekableInputStream inputStream) throws IOException {
        int percentile = (int)(timecode * 100L / this.duration);
        long frameIndex = this.frameCount * (long)percentile / 100L;
        long seekPosition = Math.min(this.firstFramePosition + this.dataSize * (long)(this.seekMapping[percentile] & 0xFF) / 256L, this.contentLength);
        inputStream.seek(seekPosition);
        return frameIndex;
    }
}

