/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BaseAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class OggAudioTrack
extends BaseAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(OggAudioTrack.class);
    private final SeekableInputStream inputStream;

    public OggAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        super(trackInfo);
        this.inputStream = inputStream;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        OggPacketInputStream packetInputStream = new OggPacketInputStream(this.inputStream, false);
        log.debug("Starting to play an OGG stream track {}", (Object)this.getIdentifier());
        localExecutor.executeProcessingLoop(() -> {
            try {
                this.processTrackLoop(packetInputStream, localExecutor.getProcessingContext());
            }
            catch (IOException e) {
                throw new FriendlyException("Stream broke when playing OGG track.", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }, null, true);
    }

    private void processTrackLoop(OggPacketInputStream packetInputStream, AudioProcessingContext context) throws IOException, InterruptedException {
        OggTrackBlueprint blueprint = OggTrackLoader.loadTrackBlueprint(packetInputStream);
        if (blueprint == null) {
            throw new IOException("Stream terminated before the first packet.");
        }
        while (blueprint != null) {
            try (OggTrackHandler handler = blueprint.loadTrackHandler(packetInputStream);){
                handler.initialise(context, 0L, 0L);
                handler.provideFrames();
            }
            blueprint = OggTrackLoader.loadTrackBlueprint(packetInputStream);
        }
    }
}

