/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.playlists;

import com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamSegment;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpGet;

public class HlsStreamSegmentParser {
    public static List<HlsStreamSegment> parseFromUrl(HttpInterface httpInterface, String url) throws IOException {
        return HlsStreamSegmentParser.parseFromLines(HttpClientTools.fetchResponseLines(httpInterface, new HttpGet(url), "stream segments list"));
    }

    public static List<HlsStreamSegment> parseFromLines(String[] lines) {
        ArrayList<HlsStreamSegment> segments = new ArrayList<HlsStreamSegment>();
        ExtendedM3uParser.Line segmentInfo = null;
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isDirective() && "EXTINF".equals(line.directiveName)) {
                segmentInfo = line;
            }
            if (!line.isData()) continue;
            if (segmentInfo != null && segmentInfo.extraData.contains(",")) {
                String[] fields = segmentInfo.extraData.split(",", 2);
                segments.add(new HlsStreamSegment(line.lineData, HlsStreamSegmentParser.parseSecondDuration(fields[0]), fields[1]));
                continue;
            }
            segments.add(new HlsStreamSegment(line.lineData, null, null));
        }
        return segments;
    }

    private static Long parseSecondDuration(String value) {
        try {
            double asDouble = Double.parseDouble(value);
            return (long)(asDouble * 1000.0);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

