/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.local;

import com.sedmelluq.discord.lavaplayer.tools.io.ExtendedBufferedInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class LocalSeekableInputStream
extends SeekableInputStream {
    private static final Logger log = LoggerFactory.getLogger(LocalSeekableInputStream.class);
    private final FileInputStream inputStream;
    private final FileChannel channel;
    private final ExtendedBufferedInputStream bufferedStream;
    private long position;

    public LocalSeekableInputStream(File file) {
        super(file.length(), 0L);
        try {
            this.inputStream = new FileInputStream(file);
            this.bufferedStream = new ExtendedBufferedInputStream(this.inputStream);
            this.channel = this.inputStream.getChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.bufferedStream.read();
        if (result >= 0) {
            ++this.position;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.bufferedStream.read(b, off, len);
        this.position += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.bufferedStream.skip(n);
        this.position += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.bufferedStream.available();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            log.debug("Failed to close channel", e);
        }
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean canSeekHard() {
        return true;
    }

    @Override
    public List<AudioTrackInfoProvider> getTrackInfoProviders() {
        return Collections.emptyList();
    }

    @Override
    protected void seekHard(long position) throws IOException {
        this.channel.position(position);
        this.position = position;
        this.bufferedStream.discardBuffer();
    }
}

