/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataReader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudFormatHandler;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHelper;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHtmlDataLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import red.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import red.felnull.imp.libs.org.apache.http.client.utils.URIBuilder;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class DefaultSoundCloudPlaylistLoader
implements SoundCloudPlaylistLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultSoundCloudPlaylistLoader.class);
    protected static final String PLAYLIST_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    protected static final Pattern playlistUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    protected final SoundCloudHtmlDataLoader htmlDataLoader;
    protected final SoundCloudDataReader dataReader;
    protected final SoundCloudFormatHandler formatHandler;

    public DefaultSoundCloudPlaylistLoader(SoundCloudHtmlDataLoader htmlDataLoader, SoundCloudDataReader dataReader, SoundCloudFormatHandler formatHandler) {
        this.htmlDataLoader = htmlDataLoader;
        this.dataReader = dataReader;
        this.formatHandler = formatHandler;
    }

    @Override
    public AudioPlaylist load(String identifier, HttpInterfaceManager httpInterfaceManager, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        String url = SoundCloudHelper.nonMobileUrl(identifier);
        if (playlistUrlPattern.matcher(url).matches()) {
            return this.loadFromSet(httpInterfaceManager, url, trackFactory);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AudioPlaylist loadFromSet(HttpInterfaceManager httpInterfaceManager, String playlistWebUrl, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        try (HttpInterface httpInterface = httpInterfaceManager.getInterface();){
            JsonBrowser rootData = this.htmlDataLoader.load(httpInterface, playlistWebUrl);
            JsonBrowser playlistData = this.dataReader.findPlaylistData(rootData);
            BasicAudioPlaylist basicAudioPlaylist = new BasicAudioPlaylist(this.dataReader.readPlaylistName(playlistData), this.loadPlaylistTracks(httpInterface, playlistData, trackFactory), null, false);
            return basicAudioPlaylist;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading playlist from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    protected List<AudioTrack> loadPlaylistTracks(HttpInterface httpInterface, JsonBrowser playlistData, Function<AudioTrackInfo, AudioTrack> trackFactory) throws IOException {
        String playlistId = this.dataReader.readPlaylistIdentifier(playlistData);
        List<String> trackIds = this.dataReader.readPlaylistTracks(playlistData).stream().map(this.dataReader::readTrackId).collect(Collectors.toList());
        int numTrackIds = trackIds.size();
        ArrayList<JsonBrowser> trackDataList = new ArrayList<JsonBrowser>();
        for (int i = 0; i < numTrackIds; i += 50) {
            int last = Math.min(i + 50, numTrackIds);
            List<String> trackIdSegment = trackIds.subList(i, last);
            try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(this.buildTrackListUrl(trackIdSegment)));){
                HttpClientTools.assertSuccessWithContent(response, "track list response");
                JsonBrowser trackList = JsonBrowser.parse(response.getEntity().getContent());
                trackDataList.addAll(trackList.values());
                continue;
            }
        }
        this.sortPlaylistTracks(trackDataList, trackIds);
        int blockedCount = 0;
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser trackData : trackDataList) {
            if (this.dataReader.isTrackBlocked(trackData)) {
                ++blockedCount;
                continue;
            }
            try {
                tracks.add(trackFactory.apply(this.dataReader.readTrackInfo(trackData, this.formatHandler.buildFormatIdentifier(this.formatHandler.chooseBestFormat(this.dataReader.readTrackFormats(trackData))))));
            }
            catch (Exception e) {
                log.error("In soundcloud playlist {}, failed to load track", (Object)playlistId, (Object)e);
            }
        }
        if (blockedCount > 0) {
            log.debug("In soundcloud playlist {}, {} tracks were omitted because they are blocked.", (Object)playlistId, (Object)blockedCount);
        }
        return tracks;
    }

    protected URI buildTrackListUrl(List<String> trackIds) {
        try {
            StringJoiner joiner = new StringJoiner(",");
            for (String trackId : trackIds) {
                joiner.add(trackId);
            }
            return new URIBuilder("https://api-v2.soundcloud.com/tracks").addParameter("ids", joiner.toString()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sortPlaylistTracks(List<JsonBrowser> trackDataList, List<String> trackIds) {
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (int i = 0; i < trackIds.size(); ++i) {
            positions.put(trackIds.get(i), i);
        }
        trackDataList.sort(Comparator.comparingInt(trackData -> positions.getOrDefault(this.dataReader.readTrackId((JsonBrowser)trackData), Integer.MAX_VALUE)));
    }
}

