/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMixLoader;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import red.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpGet;

public class YoutubeMixProvider
implements YoutubeMixLoader {
    @Override
    public AudioPlaylist load(HttpInterface httpInterface, String mixId, String selectedVideoId, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        String playlistTitle = "YouTube mix";
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        String mixUrl = "https://www.youtube.com/watch?v=" + selectedVideoId + "&list=" + mixId + "&pbj=1";
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(mixUrl));){
            HttpClientTools.assertSuccessWithContent(response, "mix response");
            JsonBrowser body = JsonBrowser.parse(response.getEntity().getContent());
            JsonBrowser playlist = body.index(3).get("response").get("contents").get("twoColumnWatchNextResults").get("playlist").get("playlist");
            JsonBrowser title = playlist.get("title");
            if (!title.isNull()) {
                playlistTitle = title.text();
            }
            this.extractPlaylistTracks(playlist.get("contents"), tracks, trackFactory);
        }
        catch (IOException e) {
            throw new FriendlyException("Could not read mix page.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        if (tracks.isEmpty()) {
            throw new FriendlyException("Could not find tracks from mix.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        AudioTrack selectedTrack = this.findSelectedTrack(tracks, selectedVideoId);
        return new BasicAudioPlaylist(playlistTitle, tracks, selectedTrack, false);
    }

    private void extractPlaylistTracks(JsonBrowser browser, List<AudioTrack> tracks, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        for (JsonBrowser video : browser.values()) {
            JsonBrowser renderer = video.get("playlistPanelVideoRenderer");
            String title = renderer.get("title").get("simpleText").text();
            String author = renderer.get("longBylineText").get("runs").index(0).get("text").text();
            String durationStr = renderer.get("lengthText").get("simpleText").text();
            long duration = this.parseDuration(durationStr);
            String identifier = renderer.get("videoId").text();
            String uri = "https://youtube.com/watch?v=" + identifier;
            AudioTrackInfo trackInfo = new AudioTrackInfo(title, author, duration, identifier, false, uri);
            tracks.add(trackFactory.apply(trackInfo));
        }
    }

    private long parseDuration(String duration) {
        String[] parts = duration.split(":");
        if (parts.length == 3) {
            int hours = Integer.parseInt(parts[0]);
            int minutes = Integer.parseInt(parts[1]);
            int seconds = Integer.parseInt(parts[2]);
            return hours * 3600000 + minutes * 60000 + seconds * 1000;
        }
        if (parts.length == 2) {
            int minutes = Integer.parseInt(parts[0]);
            int seconds = Integer.parseInt(parts[1]);
            return minutes * 60000 + seconds * 1000;
        }
        return Long.MAX_VALUE;
    }

    private AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }
}

