/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube.format;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import com.sedmelluq.discord.lavaplayer.source.youtube.format.OfflineYoutubeTrackFormatExtractor;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import red.felnull.imp.libs.org.apache.http.entity.ContentType;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class StreamingDataFormatsExtractor
implements OfflineYoutubeTrackFormatExtractor {
    private static final Logger log = LoggerFactory.getLogger(StreamingDataFormatsExtractor.class);

    @Override
    public List<YoutubeTrackFormat> extract(YoutubeTrackJsonData data) {
        JsonBrowser streamingData = data.playerResponse.get("streamingData");
        if (streamingData.isNull()) {
            return Collections.emptyList();
        }
        boolean isLive = data.playerResponse.get("videoDetails").get("isLive").asBoolean(false);
        List<YoutubeTrackFormat> formats = this.loadTrackFormatsFromStreamingData(streamingData.get("formats"), isLive);
        formats.addAll(this.loadTrackFormatsFromStreamingData(streamingData.get("adaptiveFormats"), isLive));
        return formats;
    }

    private List<YoutubeTrackFormat> loadTrackFormatsFromStreamingData(JsonBrowser formats, boolean isLive) {
        ArrayList<YoutubeTrackFormat> tracks = new ArrayList<YoutubeTrackFormat>();
        boolean anyFailures = false;
        if (!formats.isNull() && formats.isList()) {
            for (JsonBrowser formatJson : formats.values()) {
                String cipher = formatJson.get("cipher").text();
                if (cipher == null) {
                    cipher = formatJson.get("signatureCipher").text();
                }
                Map cipherInfo = cipher != null ? DataFormatTools.decodeUrlEncodedItems(cipher, true) : Collections.emptyMap();
                try {
                    long contentLength = formatJson.get("contentLength").asLong(Long.MAX_VALUE);
                    if (contentLength == Long.MAX_VALUE && !isLive) {
                        log.debug("Track not a live stream, but no contentLength in format {}, skipping", (Object)formatJson.format());
                        continue;
                    }
                    tracks.add(new YoutubeTrackFormat(ContentType.parse(formatJson.get("mimeType").text()), formatJson.get("bitrate").asLong(-1L), contentLength, cipherInfo.getOrDefault("url", formatJson.get("url").text()), (String)cipherInfo.get("s"), cipherInfo.getOrDefault("sp", "signature")));
                }
                catch (RuntimeException e) {
                    anyFailures = true;
                    log.debug("Failed to parse format {}, skipping", (Object)formatJson, (Object)e);
                }
            }
        }
        if (tracks.isEmpty() && anyFailures) {
            log.warn("In streamingData adaptive formats {}, all formats either failed to load or were skipped due to missing fields", (Object)formats.format());
        }
        return tracks;
    }
}

