/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import red.felnull.imp.libs.org.apache.commons.io.IOUtils;
import red.felnull.imp.libs.org.apache.http.NameValuePair;
import red.felnull.imp.libs.org.apache.http.client.utils.URLEncodedUtils;

public class DataFormatTools {
    private static final Pattern lineSplitPattern = Pattern.compile("[\\r\\n\\s]*\\n[\\r\\n\\s]*");

    public static String extractBetween(String haystack, String start, String end) {
        int startPosition;
        int endPosition;
        int startMatch = haystack.indexOf(start);
        if (startMatch >= 0 && (endPosition = haystack.indexOf(end, startPosition = startMatch + start.length())) >= 0) {
            return haystack.substring(startPosition, endPosition);
        }
        return null;
    }

    public static String extractBetween(String haystack, TextRange[] candidates) {
        for (TextRange candidate : candidates) {
            String result = DataFormatTools.extractBetween(haystack, candidate.start, candidate.end);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String extractAfter(String haystack, String start) {
        int startMatch = haystack.indexOf(start);
        if (startMatch >= 0) {
            return haystack.substring(startMatch + start.length());
        }
        return null;
    }

    public static String extractAfter(String haystack, String[] candidates) {
        for (String candidate : candidates) {
            String result = DataFormatTools.extractAfter(haystack, candidate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Map<String, String> convertToMapLayout(Collection<NameValuePair> pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair pair : pairs) {
            map.put(pair.getName(), pair.getValue());
        }
        return map;
    }

    public static Map<String, String> decodeUrlEncodedItems(String input, boolean escapedSeparator) {
        if (escapedSeparator) {
            input = input.replace("\\\\u0026", "&");
        }
        return DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(input, StandardCharsets.UTF_8));
    }

    public static <T> T defaultOnNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String[] streamToLines(InputStream inputStream, Charset charset) throws IOException {
        String text = IOUtils.toString(inputStream, charset);
        return lineSplitPattern.split(text);
    }

    public static long durationTextToMillis(String durationText) {
        int length = 0;
        for (String part : durationText.split("[:.]")) {
            length = length * 60 + Integer.parseInt(part);
        }
        return (long)length * 1000L;
    }

    public static void writeNullableText(DataOutput output, String text) throws IOException {
        output.writeBoolean(text != null);
        if (text != null) {
            output.writeUTF(text);
        }
    }

    public static String readNullableText(DataInput input) throws IOException {
        boolean exists = input.readBoolean();
        return exists ? input.readUTF() : null;
    }

    public static boolean arrayRangeEquals(byte[] array, int offset, byte[] segment) {
        if (array.length < offset + segment.length) {
            return false;
        }
        for (int i = 0; i < segment.length; ++i) {
            if (segment[i] == array[i + offset]) continue;
            return false;
        }
        return true;
    }

    public static class TextRange {
        public final String start;
        public final String end;

        public TextRange(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

