/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools;

import com.sedmelluq.discord.lavaplayer.tools.DecodedException;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class ExceptionTools {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTools.class);
    private static volatile ErrorDebugInfoHandler debugInfoHandler = new DefaultErrorDebugInfoHandler();

    public static void rethrowErrors(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static FriendlyException wrapUnfriendlyExceptions(String message, FriendlyException.Severity severity, Throwable throwable) {
        if (throwable instanceof FriendlyException) {
            return (FriendlyException)throwable;
        }
        return new FriendlyException(message, severity, throwable);
    }

    public static RuntimeException wrapUnfriendlyExceptions(Throwable throwable) {
        if (throwable instanceof FriendlyException) {
            return (FriendlyException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static RuntimeException toRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static <T extends Throwable> T findDeepException(Throwable throwable, Class<T> klass) {
        while (throwable != null) {
            if (klass.isAssignableFrom(throwable.getClass())) {
                return (T)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static void keepInterrupted(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void log(Logger log, FriendlyException exception, Object context) {
        switch (exception.severity) {
            case COMMON: {
                log.debug("Common failure for {}: {}", context, (Object)exception.getMessage());
                break;
            }
            case SUSPICIOUS: {
                log.warn("Suspicious exception for {}", context, (Object)exception);
                break;
            }
            default: {
                log.error("Error in {}", context, (Object)exception);
            }
        }
    }

    public static void setDebugInfoHandler(ErrorDebugInfoHandler debugInfoHandler) {
        ExceptionTools.debugInfoHandler = debugInfoHandler;
    }

    public static RuntimeException throwWithDebugInfo(Logger log, Throwable cause, String message, String name, String value) {
        ErrorDebugInfo debugInfo = new ErrorDebugInfo(log, UUID.randomUUID().toString(), cause, message, name, value);
        debugInfoHandler.handle(debugInfo);
        return new RuntimeException(message + " EID: " + debugInfo.errorId + ", " + name + " <redacted>", cause);
    }

    public static void encodeException(DataOutput output, FriendlyException exception) throws IOException {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        for (Throwable next = exception.getCause(); next != null; next = next.getCause()) {
            causes.add(next);
        }
        for (int i = causes.size() - 1; i >= 0; --i) {
            String message;
            Throwable cause = (Throwable)causes.get(i);
            output.writeBoolean(true);
            if (cause instanceof DecodedException) {
                output.writeUTF(((DecodedException)cause).className);
                message = ((DecodedException)cause).originalMessage;
            } else {
                output.writeUTF(cause.getClass().getName());
                message = cause.getMessage();
            }
            output.writeBoolean(message != null);
            if (message != null) {
                output.writeUTF(message);
            }
            ExceptionTools.encodeStackTrace(output, cause);
        }
        output.writeBoolean(false);
        output.writeUTF(exception.getMessage());
        output.writeInt(exception.severity.ordinal());
        ExceptionTools.encodeStackTrace(output, exception);
    }

    public static void closeWithWarnings(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            log.warn("Failed to close.", e);
        }
    }

    private static void encodeStackTrace(DataOutput output, Throwable throwable) throws IOException {
        StackTraceElement[] trace = throwable.getStackTrace();
        output.writeInt(trace.length);
        for (StackTraceElement element : trace) {
            output.writeUTF(element.getClassName());
            output.writeUTF(element.getMethodName());
            String fileName = element.getFileName();
            output.writeBoolean(fileName != null);
            if (fileName != null) {
                output.writeUTF(fileName);
            }
            output.writeInt(element.getLineNumber());
        }
    }

    public static FriendlyException decodeException(DataInput input) throws IOException {
        DecodedException cause = null;
        while (input.readBoolean()) {
            cause = new DecodedException(input.readUTF(), input.readBoolean() ? input.readUTF() : null, cause);
            cause.setStackTrace(ExceptionTools.decodeStackTrace(input));
        }
        FriendlyException exception = new FriendlyException(input.readUTF(), ((FriendlyException.Severity[])FriendlyException.Severity.class.getEnumConstants())[input.readInt()], cause);
        exception.setStackTrace(ExceptionTools.decodeStackTrace(input));
        return exception;
    }

    private static StackTraceElement[] decodeStackTrace(DataInput input) throws IOException {
        StackTraceElement[] trace = new StackTraceElement[input.readInt()];
        for (int i = 0; i < trace.length; ++i) {
            trace[i] = new StackTraceElement(input.readUTF(), input.readUTF(), input.readBoolean() ? input.readUTF() : null, input.readInt());
        }
        return trace;
    }

    public static class DefaultErrorDebugInfoHandler
    implements ErrorDebugInfoHandler {
        @Override
        public void handle(ErrorDebugInfo debugInfo) {
            log.warn("{} EID: {}, {}: {}", debugInfo.message, debugInfo.errorId, debugInfo.name, debugInfo.value);
        }
    }

    public static interface ErrorDebugInfoHandler {
        public void handle(ErrorDebugInfo var1);
    }

    public static class ErrorDebugInfo {
        public final Logger log;
        public final String errorId;
        public final Throwable cause;
        public final String message;
        public final String name;
        public final String value;

        public ErrorDebugInfo(Logger log, String errorId, Throwable cause, String message, String name, String value) {
            this.log = log;
            this.errorId = errorId;
            this.cause = cause;
            this.message = message;
            this.name = name;
            this.value = value;
        }
    }
}

