/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import red.felnull.imp.block.IMPAbstractBlock;
import red.felnull.imp.block.voxelshape.CassetteStorageVoxelShape;
import red.felnull.imp.tileentity.CassetteStorageTileEntity;

public class CassetteStorageBlock
extends IMPAbstractBlock {
    protected CassetteStorageBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Override
    public VoxelShape getFacingShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context, Direction direction) {
        if (!((Boolean)state.func_177229_b((Property)WALL)).booleanValue()) {
            switch (direction) {
                case NORTH: {
                    return CassetteStorageVoxelShape.SOUTH_AXIS_AABB;
                }
                case SOUTH: {
                    return CassetteStorageVoxelShape.NORTH_AXIS_AABB;
                }
                case EAST: {
                    return CassetteStorageVoxelShape.WEST_AXIS_AABB;
                }
                case WEST: {
                    return CassetteStorageVoxelShape.EAST_AXIS_AABB;
                }
            }
            return CassetteStorageVoxelShape.NORTH_AXIS_AABB;
        }
        switch (direction) {
            case NORTH: {
                return CassetteStorageVoxelShape.SOUTH_WALL_AXIS_AABB;
            }
            case SOUTH: {
                return CassetteStorageVoxelShape.NORTH_WALL_AXIS_AABB;
            }
            case EAST: {
                return CassetteStorageVoxelShape.WEST_WALL_AXIS_AABB;
            }
            case WEST: {
                return CassetteStorageVoxelShape.EAST_WALL_AXIS_AABB;
            }
        }
        return CassetteStorageVoxelShape.NORTH_WALL_AXIS_AABB;
    }

    @Override
    public boolean isWallHanging() {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CassetteStorageTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof CassetteStorageTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((INamedContainerProvider)tileentity), (BlockPos)pos);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }
}

