/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import red.felnull.imp.block.propertie.IMPBlockStateProperties;
import red.felnull.imp.tileentity.IMPAbstractTileEntity;
import red.felnull.otyacraftengine.util.IKSGEntityUtil;

public abstract class IMPAbstractBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty WALL = IMPBlockStateProperties.WALL;

    public IMPAbstractBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (this.isWallHanging()) {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WALL, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction;
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a));
        if (this.isWallHanging() && (direction = context.func_196000_l()) != Direction.DOWN && direction != Direction.UP) {
            state = (BlockState)state.func_206870_a((Property)WALL, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)direction);
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED});
        if (this.isWallHanging()) {
            blockBlockStateBuilder.func_206894_a(new Property[]{WALL});
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D);
        return this.getFacingShape(state, worldIn, pos, context, direction);
    }

    public abstract VoxelShape getFacingShape(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4, Direction var5);

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (this.isWallHanging() && ((Boolean)stateIn.func_177229_b((Property)WALL)).booleanValue()) {
            Direction direction = (Direction)stateIn.func_177229_b((Property)field_185512_D);
            return facing == direction.func_176746_e().func_176746_e() && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
        }
        return facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (!this.isStickingBlock()) {
            return super.func_196260_a(state, worldIn, pos);
        }
        if (this.isWallHanging() && ((Boolean)state.func_177229_b((Property)WALL)).booleanValue()) {
            Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
            return IMPAbstractBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction.func_176746_e().func_176746_e()), (Direction)Direction.UP);
        }
        return IMPAbstractBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_196243_a(BlockState before, World worldIn, BlockPos pos, BlockState after, boolean isMoving) {
        if (before.func_177230_c() != after.func_177230_c() && this.hasTileEntity(before) && worldIn.func_175625_s(pos) instanceof IMPAbstractTileEntity) {
            IMPAbstractTileEntity tileentity = (IMPAbstractTileEntity)worldIn.func_175625_s(pos);
            tileentity.getItems().forEach(n -> {
                ItemEntity dropItem = IKSGEntityUtil.createItemEntity((ItemStack)n, (World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
                worldIn.func_217376_c((Entity)dropItem);
            });
            tileentity.func_174888_l();
        }
        super.func_196243_a(before, worldIn, pos, after, isMoving);
    }

    public boolean isWallHanging() {
        return false;
    }

    public boolean isStickingBlock() {
        return false;
    }
}

