/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.data;

import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import red.felnull.imp.client.music.player.IMusicPlayer;
import red.felnull.imp.client.music.player.LavaMusicLoader;
import red.felnull.imp.client.music.player.URLNotStreamMusicPlayer;
import red.felnull.imp.client.music.player.YoutubeMusicPlayer;
import red.felnull.imp.exception.IMPFFmpegException;
import red.felnull.imp.exception.IMPWorldMusicException;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;
import red.felnull.imp.music.resource.PlayLocation;
import red.felnull.imp.music.resource.PlayMusic;

public enum MusicSourceClientReferencesType {
    YOUTUBE(new ResourceLocation("iammusicplayer", "textures/gui/music_source_references/youtube.png"), PlayLocation.LocationType.YOUTUBE),
    URL(new ResourceLocation("iammusicplayer", "textures/gui/music_source_references/url.png"), PlayLocation.LocationType.URL);

    private final ResourceLocation textuerLocation;
    private final PlayLocation.LocationType lctype;
    private static final LavaMusicLoader urlMusicLoader;
    private static final LavaMusicLoader youtubeMusicLoader;

    private MusicSourceClientReferencesType(ResourceLocation textuerLocation, PlayLocation.LocationType locationType) {
        this.textuerLocation = textuerLocation;
        this.lctype = locationType;
    }

    public ResourceLocation getTextuerLocation() {
        return this.textuerLocation;
    }

    public PlayLocation.LocationType getLocationType() {
        return this.lctype;
    }

    public static MusicSourceClientReferencesType getTypeByLocationType(PlayLocation.LocationType type) {
        return Arrays.stream(MusicSourceClientReferencesType.values()).filter(n -> n.getLocationType() == type).findFirst().get();
    }

    public static IMusicPlayer getMusicPlayer(PlayMusic music) throws YoutubeException, IOException, IMPWorldMusicException, InterruptedException, IMPFFmpegException {
        return MusicSourceClientReferencesType.getTypeByLocationType(music.getMusicLocation().getLocationType()).getMusicPlayer(music.getMusicLocation().getIdOrURL());
    }

    public IMusicPlayer getMusicPlayer(String src) throws YoutubeException, IOException {
        long rerytime = System.currentTimeMillis();
        switch (this) {
            case YOUTUBE: {
                return new YoutubeMusicPlayer(rerytime, src, urlMusicLoader, youtubeMusicLoader);
            }
            case URL: {
                return new URLNotStreamMusicPlayer(rerytime, new URL(src), urlMusicLoader);
            }
        }
        return null;
    }

    static {
        urlMusicLoader = new LavaMusicLoader(new HttpAudioSourceManager());
        youtubeMusicLoader = new LavaMusicLoader(new YoutubeAudioSourceManager());
    }
}

