/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.data;

import net.minecraft.util.text.TranslationTextComponent;
import red.felnull.imp.music.resource.PlayImage;

public class MusicUploadData {
    private final String name;
    private UploadState state;
    private float progress;
    private final PlayImage image;
    private final byte[] imageData;

    public MusicUploadData(String name, PlayImage image, byte[] imageData) {
        this.name = name;
        this.state = UploadState.PREPARATION;
        this.progress = 0.0f;
        this.image = image;
        this.imageData = imageData;
    }

    public float getProgress() {
        return this.progress;
    }

    public UploadState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void setState(UploadState state) {
        this.state = state;
    }

    public PlayImage getImage() {
        return this.image;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public static enum UploadState {
        PREPARATION(false, new TranslationTextComponent("uploadstate.preparation")),
        CONVERTING(true, new TranslationTextComponent("uploadstate.converting")),
        COMPRESSING(false, new TranslationTextComponent("uploadstate.compressing")),
        SENDING(true, new TranslationTextComponent("uploadstate.sending")),
        UNZIPPING(false, new TranslationTextComponent("uploadstate.unzipping")),
        COMPLETION(false, new TranslationTextComponent("uploadstate.completion")),
        ERROR(false, new TranslationTextComponent("uploadstate.error"));

        private final boolean progressble;
        private final TranslationTextComponent localized;

        private UploadState(boolean progressble, TranslationTextComponent localized) {
            this.localized = localized;
            this.progressble = progressble;
        }

        public TranslationTextComponent getLocalized() {
            return this.localized;
        }

        public boolean isProgressble() {
            return this.progressble;
        }
    }
}

